/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mekanism.client.gui.GuiPortableTeleporter;
import mekanism.common.frequency.Frequency;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketPortableTeleporter {
    private List<Frequency> publicCache;
    private List<Frequency> privateCache;
    private Frequency frequency;
    private Hand currentHand;
    private byte status;

    public PacketPortableTeleporter(Hand hand, Frequency freq, byte b, List<Frequency> publicFreqs, List<Frequency> privateFreqs) {
        this.currentHand = hand;
        this.frequency = freq;
        this.status = b;
        this.publicCache = publicFreqs;
        this.privateCache = privateFreqs;
    }

    public static void handle(PacketPortableTeleporter message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiPortableTeleporter) {
                GuiPortableTeleporter teleporter = (GuiPortableTeleporter)screen;
                teleporter.setStatus(message.status);
                teleporter.setFrequency(message.frequency);
                teleporter.setPublicCache(message.publicCache);
                teleporter.setPrivateCache(message.privateCache);
                teleporter.updateButtons();
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketPortableTeleporter pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.currentHand);
        if (pkt.frequency == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_180714_a(pkt.frequency.name);
            buf.writeBoolean(pkt.frequency.publicFreq);
        }
        buf.writeByte((int)pkt.status);
        buf.func_150787_b(pkt.publicCache.size());
        for (Frequency freq : pkt.publicCache) {
            freq.write(buf);
        }
        buf.func_150787_b(pkt.privateCache.size());
        for (Frequency freq : pkt.privateCache) {
            freq.write(buf);
        }
    }

    public static PacketPortableTeleporter decode(PacketBuffer buf) {
        int i;
        Hand currentHand = (Hand)buf.func_179257_a(Hand.class);
        ArrayList<Frequency> publicCache = new ArrayList<Frequency>();
        ArrayList<Frequency> privateCache = new ArrayList<Frequency>();
        Frequency frequency = null;
        if (buf.readBoolean()) {
            frequency = new Frequency(BasePacketHandler.readString(buf), null).setPublic(buf.readBoolean());
        }
        byte status = buf.readByte();
        int amount = buf.func_150792_a();
        for (i = 0; i < amount; ++i) {
            publicCache.add(Frequency.readFromPacket(buf));
        }
        amount = buf.func_150792_a();
        for (i = 0; i < amount; ++i) {
            privateCache.add(Frequency.readFromPacket(buf));
        }
        return new PacketPortableTeleporter(currentHand, frequency, status, publicCache, privateCache);
    }
}

