/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multiblock;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class SynchronizedData<T extends SynchronizedData<T>>
implements IMekanismInventory {
    public Set<Coord4D> locations = new ObjectOpenHashSet();
    public Set<IValveHandler.ValveData> valves = new ObjectOpenHashSet();
    public Set<Coord4D> internalLocations = new ObjectOpenHashSet();
    public int volLength;
    public int volWidth;
    public int volHeight;
    private int volume;
    public UUID inventoryID;
    public boolean didTick;
    public boolean hasRenderer;
    @Nullable
    public Coord4D renderLocation;
    public Coord4D minLocation;
    public Coord4D maxLocation;
    public boolean destroyed;
    private int currentRedstoneLevel;

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction side) {
        return Collections.emptyList();
    }

    public Set<Direction> getDirectionsToEmit(Coord4D coord) {
        EnumSet<Direction> directionsToEmit = EnumSet.noneOf(Direction.class);
        for (Direction direction : EnumUtils.DIRECTIONS) {
            if (this.locations.contains(coord.offset(direction))) continue;
            directionsToEmit.add(direction);
        }
        return directionsToEmit;
    }

    @Override
    public void onContentsChanged() {
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.locations.hashCode();
        code = 31 * code + this.volLength;
        code = 31 * code + this.volWidth;
        code = 31 * code + this.volHeight;
        code = 31 * code + this.getVolume();
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SynchronizedData data = (SynchronizedData)obj;
        if (!data.locations.equals(this.locations)) {
            return false;
        }
        if (data.volLength != this.volLength || data.volWidth != this.volWidth || data.volHeight != this.volHeight) {
            return false;
        }
        return data.getVolume() == this.getVolume();
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public void onCreated() {
        this.forceUpdateComparatorLevel();
    }

    public void markDirtyComparator(World world) {
        int newRedstoneLevel = this.getMultiblockRedstoneLevel();
        if (newRedstoneLevel != this.currentRedstoneLevel) {
            this.currentRedstoneLevel = newRedstoneLevel;
            this.notifyAllUpdateComparator(world);
        }
    }

    public void notifyAllUpdateComparator(World world) {
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityMultiblock tile = MekanismUtils.getTileEntity(TileEntityMultiblock.class, (IBlockReader)world, valve.location.getPos());
            if (tile == null) continue;
            tile.markDirtyComparator();
        }
    }

    public void forceUpdateComparatorLevel() {
        this.currentRedstoneLevel = this.getMultiblockRedstoneLevel();
    }

    protected abstract int getMultiblockRedstoneLevel();

    public int getCurrentRedstoneLevel() {
        return this.currentRedstoneLevel;
    }
}

