/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.IChemicalHandlerWrapper;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionHandlerWrapper;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.ChemicalInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InfusionInventorySlot
extends ChemicalInventorySlot<InfuseType, InfusionStack> {
    @Nullable
    public static IChemicalHandlerWrapper<InfuseType, InfusionStack> getCapabilityWrapper(ItemStack stack) {
        Optional capability;
        if (!stack.func_190926_b() && (capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY))).isPresent()) {
            return new InfusionHandlerWrapper((IInfusionHandler)capability.get());
        }
        return null;
    }

    private static InfusionStack getPotentialConversion(@Nullable World world, ItemStack itemStack) {
        ItemStackToInfuseTypeRecipe foundRecipe = MekanismRecipeType.INFUSION_CONVERSION.findFirst(world, recipe -> recipe.getInput().testType(itemStack));
        return foundRecipe == null ? InfusionStack.EMPTY : foundRecipe.getOutput(itemStack);
    }

    public static InfusionInventorySlot fillOrConvert(IInfusionTank infusionTank, Supplier<World> worldSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(infusionTank, "Infusion tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        Function<ItemStack, InfusionStack> potentialConversionSupplier = stack -> InfusionInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
        return new InfusionInventorySlot(infusionTank, worldSupplier, InfusionInventorySlot.getFillOrConvertExtractPredicate(infusionTank, InfusionInventorySlot::getCapabilityWrapper, potentialConversionSupplier), InfusionInventorySlot.getFillOrConvertInsertPredicate(infusionTank, InfusionInventorySlot::getCapabilityWrapper, potentialConversionSupplier), stack -> {
            if (stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent()) {
                return true;
            }
            InfusionStack conversion = InfusionInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
            return !conversion.isEmpty() && infusionTank.isValid(conversion);
        }, inventory, x, y);
    }

    private InfusionInventorySlot(IInfusionTank infusionTank, Supplier<World> worldSupplier, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        super(infusionTank, worldSupplier, canExtract, canInsert, validator, inventory, x, y);
    }

    @Override
    @Nullable
    protected IChemicalHandlerWrapper<InfuseType, InfusionStack> getCapabilityWrapper() {
        return InfusionInventorySlot.getCapabilityWrapper(this.current);
    }

    @Override
    @Nullable
    protected Pair<ItemStack, InfusionStack> getConversion() {
        ItemStack itemInput;
        ItemStackToInfuseTypeRecipe foundRecipe = MekanismRecipeType.INFUSION_CONVERSION.findFirst((World)this.worldSupplier.get(), recipe -> recipe.getInput().test(this.current));
        if (foundRecipe != null && !(itemInput = foundRecipe.getInput().getMatchingInstance(this.current)).func_190926_b()) {
            return Pair.of((Object)itemInput, (Object)foundRecipe.getOutput(itemInput));
        }
        return null;
    }
}

