/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandlerWrapper;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalInventorySlot<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends BasicInventorySlot {
    protected final Supplier<World> worldSupplier;
    protected final IChemicalTank<CHEMICAL, STACK> chemicalTank;

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NonNull ItemStack> getFillOrConvertExtractPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NonNull ItemStack, IChemicalHandlerWrapper<CHEMICAL, STACK>> wrapperFunction, Function<ItemStack, STACK> potentialConversionSupplier) {
        return stack -> {
            ChemicalStack conversion;
            IChemicalHandlerWrapper wrapper = (IChemicalHandlerWrapper)wrapperFunction.apply((ItemStack)stack);
            if (wrapper != null) {
                for (int tank = 0; tank < wrapper.getTanks(); ++tank) {
                    if (!chemicalTank.isValid(wrapper.getChemicalInTank(tank))) continue;
                    return false;
                }
            }
            return (conversion = (ChemicalStack)potentialConversionSupplier.apply((ItemStack)stack)).isEmpty() || !chemicalTank.isValid(conversion);
        };
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NonNull ItemStack> getFillOrConvertInsertPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NonNull ItemStack, IChemicalHandlerWrapper<CHEMICAL, STACK>> wrapperFunction, Function<ItemStack, STACK> potentialConversionSupplier) {
        return stack -> {
            if (ChemicalInventorySlot.fillInsertCheck(chemicalTank, (IChemicalHandlerWrapper)wrapperFunction.apply((ItemStack)stack))) {
                return true;
            }
            ChemicalStack conversion = (ChemicalStack)potentialConversionSupplier.apply((ItemStack)stack);
            return !conversion.isEmpty() && chemicalTank.insert(conversion, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < conversion.getAmount();
        };
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NonNull ItemStack> getFillExtractPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NonNull ItemStack, IChemicalHandlerWrapper<CHEMICAL, STACK>> wrapperFunction) {
        return stack -> {
            IChemicalHandlerWrapper wrapper = (IChemicalHandlerWrapper)wrapperFunction.apply((ItemStack)stack);
            if (wrapper != null) {
                for (int tank = 0; tank < wrapper.getTanks(); ++tank) {
                    if (!chemicalTank.isValid(wrapper.getChemicalInTank(tank))) continue;
                    return false;
                }
            }
            return true;
        };
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean fillInsertCheck(IChemicalTank<CHEMICAL, STACK> chemicalTank, @Nullable IChemicalHandlerWrapper<CHEMICAL, STACK> wrapper) {
        if (wrapper != null) {
            for (int tank = 0; tank < wrapper.getTanks(); ++tank) {
                STACK chemicalInTank = wrapper.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalInTank).isEmpty() || ((ChemicalStack)chemicalTank.insert(chemicalInTank, Action.SIMULATE, AutomationType.INTERNAL)).getAmount() >= ((ChemicalStack)chemicalInTank).getAmount()) continue;
                return true;
            }
        }
        return false;
    }

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Predicate<@NonNull ItemStack> getDrainInsertPredicate(IChemicalTank<CHEMICAL, STACK> chemicalTank, Function<@NonNull ItemStack, IChemicalHandlerWrapper<CHEMICAL, STACK>> wrapperFunction) {
        return stack -> {
            IChemicalHandlerWrapper wrapper = (IChemicalHandlerWrapper)wrapperFunction.apply((ItemStack)stack);
            if (wrapper != null) {
                if (chemicalTank.isEmpty()) {
                    for (int tank = 0; tank < wrapper.getTanks(); ++tank) {
                        if (((ChemicalStack)wrapper.getChemicalInTank(tank)).getAmount() >= wrapper.getTankCapacity(tank)) continue;
                        return true;
                    }
                    return false;
                }
                return ((ChemicalStack)wrapper.insertChemical(chemicalTank.getStack(), Action.SIMULATE)).getAmount() < chemicalTank.getStored();
            }
            return false;
        };
    }

    protected ChemicalInventorySlot(IChemicalTank<CHEMICAL, STACK> chemicalTank, Supplier<World> worldSupplier, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        super(canExtract, canInsert, validator, inventory, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.chemicalTank = chemicalTank;
        this.worldSupplier = worldSupplier;
    }

    @Nullable
    protected abstract IChemicalHandlerWrapper<CHEMICAL, STACK> getCapabilityWrapper();

    @Nullable
    protected abstract Pair<ItemStack, STACK> getConversion();

    public void fillTankOrConvert() {
        ChemicalStack output;
        Pair<ItemStack, STACK> conversion;
        if (!this.isEmpty() && this.chemicalTank.getNeeded() > 0L && !this.fillTankFromItem() && (conversion = this.getConversion()) != null && !(output = (ChemicalStack)conversion.getSecond()).isEmpty() && this.chemicalTank.insert(output, Action.SIMULATE, AutomationType.MANUAL).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(this.chemicalTank.insert(output, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            int amountUsed = ((ItemStack)conversion.getFirst()).func_190916_E();
            MekanismUtils.logMismatchedStackSize(this.shrinkStack(amountUsed, Action.EXECUTE), amountUsed);
        }
    }

    public void fillTank() {
        if (!this.isEmpty() && this.chemicalTank.getNeeded() > 0L) {
            this.fillTankFromItem();
        }
    }

    private boolean fillTankFromItem() {
        IChemicalHandlerWrapper<CHEMICAL, STACK> wrapper = this.getCapabilityWrapper();
        if (wrapper != null) {
            boolean didTransfer = false;
            for (int tank = 0; tank < wrapper.getTanks(); ++tank) {
                STACK extractedChemical;
                STACK chemicalInItem = wrapper.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalInItem).isEmpty()) continue;
                STACK simulatedRemainder = this.chemicalTank.insert(chemicalInItem, Action.SIMULATE, AutomationType.INTERNAL);
                long chemicalInItemAmount = ((ChemicalStack)chemicalInItem).getAmount();
                long remainder = ((ChemicalStack)simulatedRemainder).getAmount();
                if (remainder >= chemicalInItemAmount || ((ChemicalStack)(extractedChemical = wrapper.extractChemical(tank, chemicalInItemAmount - remainder, Action.EXECUTE))).isEmpty()) continue;
                MekanismUtils.logMismatchedStackSize(((ChemicalStack)this.chemicalTank.insert(extractedChemical, Action.EXECUTE, AutomationType.INTERNAL)).getAmount(), 0L);
                didTransfer = true;
                if (this.chemicalTank.getNeeded() == 0L) break;
            }
            if (didTransfer) {
                this.onContentsChanged();
                return true;
            }
        }
        return false;
    }

    public void drainTank() {
        STACK extractedChemical;
        long amount;
        STACK storedChemical;
        STACK simulatedRemainder;
        long remainder;
        IChemicalHandlerWrapper<CHEMICAL, STACK> wrapper;
        if (!(this.isEmpty() || this.chemicalTank.isEmpty() || (wrapper = this.getCapabilityWrapper()) == null || (remainder = ((ChemicalStack)(simulatedRemainder = wrapper.insertChemical(storedChemical = this.chemicalTank.getStack(), Action.SIMULATE))).getAmount()) >= (amount = ((ChemicalStack)storedChemical).getAmount()) || ((ChemicalStack)(extractedChemical = this.chemicalTank.extract(amount - remainder, Action.EXECUTE, AutomationType.INTERNAL))).isEmpty())) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)wrapper.insertChemical(extractedChemical, Action.EXECUTE)).getAmount(), 0L);
            this.onContentsChanged();
        }
    }
}

