/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableByte;
import mekanism.common.inventory.container.sync.SyncableChemicalStack;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableFloat;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableFluidStack;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.SyncableGasStack;
import mekanism.common.inventory.container.sync.SyncableInfusionStack;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.container.sync.SyncableShort;
import mekanism.common.inventory.container.sync.list.SyncableList;
import mekanism.common.network.container.PacketUpdateContainerBatch;
import mekanism.common.network.container.property.PropertyData;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.fluids.FluidStack;

public abstract class MekanismContainer
extends Container {
    public static int BASE_Y_OFFSET = 84;
    @Nullable
    protected final PlayerInventory inv;
    protected final List<InventoryContainerSlot> inventoryContainerSlots = new ArrayList<InventoryContainerSlot>();
    protected final List<MainInventorySlot> mainInventorySlots = new ArrayList<MainInventorySlot>();
    protected final List<HotBarSlot> hotBarSlots = new ArrayList<HotBarSlot>();
    private final List<ISyncableData> trackedData = new ArrayList<ISyncableData>();

    protected MekanismContainer(ContainerTypeRegistryObject<?> type, int id, @Nullable PlayerInventory inv) {
        super(type.getContainerType(), id);
        this.inv = inv;
    }

    @Nonnull
    protected Slot func_75146_a(@Nonnull Slot slot) {
        slot.field_75222_d = this.field_75151_b.size();
        this.field_75151_b.add(slot);
        this.track(SyncableItemStack.create(() -> ((Slot)slot).func_75211_c(), arg_0 -> ((Slot)slot).func_75215_d(arg_0)));
        if (slot instanceof InventoryContainerSlot) {
            this.inventoryContainerSlots.add((InventoryContainerSlot)slot);
        } else if (slot instanceof MainInventorySlot) {
            this.mainInventorySlots.add((MainInventorySlot)slot);
        } else if (slot instanceof HotBarSlot) {
            this.hotBarSlots.add((HotBarSlot)slot);
        }
        return slot;
    }

    protected void addSlotsAndOpen() {
        this.addSlots();
        if (this.inv != null) {
            this.addInventorySlots(this.inv);
            this.openInventory(this.inv);
        }
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return true;
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.closeInventory(player);
    }

    protected void closeInventory(PlayerEntity player) {
    }

    protected void openInventory(@Nonnull PlayerInventory inv) {
    }

    protected int getInventoryYOffset() {
        return BASE_Y_OFFSET;
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected void addInventorySlots(@Nonnull PlayerInventory inv) {
        int slotY;
        if (this instanceof IEmptyContainer) {
            return;
        }
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        for (slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new MainInventorySlot((IInventory)inv, slotX + slotY * 9 + 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (slotY = 0; slotY < 9; ++slotY) {
            this.func_75146_a(new HotBarSlot((IInventory)inv, slotY, xOffset + slotY * 18, yOffset));
        }
    }

    protected void addSlots() {
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int slotID) {
        ItemStack slotStack;
        Slot currentSlot = (Slot)this.field_75151_b.get(slotID);
        if (currentSlot == null || !currentSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackToInsert = slotStack = currentSlot.func_75211_c();
        if (currentSlot instanceof InventoryContainerSlot) {
            stackToInsert = this.insertItem(this.hotBarSlots, stackToInsert, true);
            stackToInsert = this.insertItem(this.mainInventorySlots, stackToInsert, true);
            stackToInsert = this.insertItem(this.mainInventorySlots, stackToInsert, false);
            stackToInsert = this.insertItem(this.hotBarSlots, stackToInsert, false);
        } else {
            stackToInsert = this.insertItem(this.inventoryContainerSlots, stackToInsert, true);
            if (slotStack.func_190916_E() == stackToInsert.func_190916_E()) {
                stackToInsert = this.insertItem(this.inventoryContainerSlots, stackToInsert, false);
                if (slotStack.func_190916_E() == stackToInsert.func_190916_E()) {
                    if (currentSlot instanceof MainInventorySlot) {
                        stackToInsert = this.insertItem(this.hotBarSlots, stackToInsert, true);
                        stackToInsert = this.insertItem(this.hotBarSlots, stackToInsert, false);
                    } else if (currentSlot instanceof HotBarSlot) {
                        stackToInsert = this.insertItem(this.mainInventorySlots, stackToInsert, true);
                        stackToInsert = this.insertItem(this.mainInventorySlots, stackToInsert, false);
                    }
                }
            }
        }
        if (stackToInsert.func_190916_E() == slotStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        int difference = slotStack.func_190916_E() - stackToInsert.func_190916_E();
        currentSlot.func_75209_a(difference);
        ItemStack newStack = StackUtils.size(slotStack, difference);
        currentSlot.func_190901_a(player, newStack);
        return newStack;
    }

    @Nonnull
    private <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty) {
        if (stack.func_190926_b()) {
            return stack;
        }
        for (Slot slot : slots) {
            if (ignoreEmpty && slot.func_75211_c().func_190926_b() || !(stack = ((IInsertableSlot)slot).insertItem(stack, Action.EXECUTE)).func_190926_b()) continue;
            break;
        }
        return stack;
    }

    public void track(ISyncableData data) {
        this.trackedData.add(data);
    }

    @Nonnull
    protected IntReferenceHolder func_216958_a(@Nonnull IntReferenceHolder referenceHolder) {
        this.track(SyncableInt.create(() -> ((IntReferenceHolder)referenceHolder).func_221495_b(), arg_0 -> ((IntReferenceHolder)referenceHolder).func_221494_a(arg_0)));
        return referenceHolder;
    }

    public void trackArray(boolean[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableBoolean.create(arrayIn, i));
        }
    }

    public void trackArray(byte[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableByte.create(arrayIn, i));
        }
    }

    public void trackArray(double[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableDouble.create(arrayIn, i));
        }
    }

    public void trackArray(float[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableFloat.create(arrayIn, i));
        }
    }

    public void trackArray(int[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableInt.create(arrayIn, i));
        }
    }

    public void trackArray(long[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableLong.create(arrayIn, i));
        }
    }

    public void trackArray(short[] arrayIn) {
        for (int i = 0; i < arrayIn.length; ++i) {
            this.track(SyncableShort.create(arrayIn, i));
        }
    }

    public void handleWindowProperty(short property, boolean value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableBoolean) {
            ((SyncableBoolean)data).set(value);
        }
    }

    public void handleWindowProperty(short property, byte value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableByte) {
            ((SyncableByte)data).set(value);
        }
    }

    public void handleWindowProperty(short property, short value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableShort) {
            ((SyncableShort)data).set(value);
        } else if (data instanceof SyncableFloatingLong) {
            ((SyncableFloatingLong)data).setDecimal(value);
        }
    }

    public void handleWindowProperty(short property, int value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableInt) {
            ((SyncableInt)data).set(value);
        } else if (data instanceof SyncableEnum) {
            ((SyncableEnum)data).set(value);
        } else if (data instanceof SyncableFluidStack) {
            ((SyncableFluidStack)data).set(value);
        } else if (data instanceof SyncableItemStack) {
            ((SyncableItemStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, long value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableLong) {
            ((SyncableLong)data).set(value);
        } else if (data instanceof SyncableChemicalStack) {
            ((SyncableChemicalStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, float value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFloat) {
            ((SyncableFloat)data).set(value);
        }
    }

    public void handleWindowProperty(short property, double value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableDouble) {
            ((SyncableDouble)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull ItemStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableItemStack) {
            ((SyncableItemStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull FluidStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFluidStack) {
            ((SyncableFluidStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull GasStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableGasStack) {
            ((SyncableGasStack)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull InfusionStack value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableInfusionStack) {
            ((SyncableInfusionStack)data).set(value);
        }
    }

    public <FREQUENCY extends Frequency> void handleWindowProperty(short property, @Nullable FREQUENCY value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFrequency) {
            ((SyncableFrequency)data).set(value);
        }
    }

    public void handleWindowProperty(short property, @Nonnull FloatingLong value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableFloatingLong) {
            ((SyncableFloatingLong)data).set(value);
        }
    }

    public <TYPE> void handleWindowProperty(short property, @Nonnull List<TYPE> value) {
        ISyncableData data = this.trackedData.get(property);
        if (data instanceof SyncableList) {
            ((SyncableList)data).set(value);
        }
    }

    public void func_75142_b() {
        if (!this.field_75149_d.isEmpty()) {
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            for (short i = 0; i < this.trackedData.size(); i = (short)(i + 1)) {
                ISyncableData data = this.trackedData.get(i);
                ISyncableData.DirtyType dirtyType = data.isDirty();
                if (dirtyType == ISyncableData.DirtyType.CLEAN) continue;
                dirtyData.add(data.getPropertyData(i, dirtyType));
            }
            int size = dirtyData.size();
            if (size == 1) {
                this.sendChange(((PropertyData)dirtyData.get(0)).getSinglePacket((short)this.field_75152_c));
            } else if (size > 1) {
                this.sendChange(new PacketUpdateContainerBatch((short)this.field_75152_c, dirtyData));
            }
        }
    }

    private <MSG> void sendChange(MSG packet) {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            Mekanism.packetHandler.sendTo(packet, (ServerPlayerEntity)listener);
        }
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        boolean alreadyHas = this.field_75149_d.contains(listener);
        super.func_75132_a(listener);
        if (!alreadyHas && listener instanceof ServerPlayerEntity) {
            ArrayList<PropertyData> dirtyData = new ArrayList<PropertyData>();
            for (short i = 0; i < this.trackedData.size(); i = (short)(i + 1)) {
                dirtyData.add(this.trackedData.get(i).getPropertyData(i, ISyncableData.DirtyType.DIRTY));
            }
            int size = dirtyData.size();
            if (size == 1) {
                Mekanism.packetHandler.sendTo(((PropertyData)dirtyData.get(0)).getSinglePacket((short)this.field_75152_c), (ServerPlayerEntity)listener);
            } else if (size > 1) {
                Mekanism.packetHandler.sendTo(new PacketUpdateContainerBatch((short)this.field_75152_c, dirtyData), (ServerPlayerEntity)listener);
            }
        }
    }
}

