/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@RecipeTypeMapper
public class CombinerRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekCombiner";
    }

    public String getDescription() {
        return "Maps Mekanism combiner recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.COMBINING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof CombinerRecipe)) {
            return false;
        }
        boolean handled = false;
        CombinerRecipe recipe = (CombinerRecipe)iRecipe;
        List<@NonNull TYPE> mainRepresentations = recipe.getMainInput().getRepresentations();
        List<@NonNull TYPE> extraRepresentations = recipe.getExtraInput().getRepresentations();
        for (ItemStack mainRepresentation : mainRepresentations) {
            NSSItem nssMain = NSSItem.createItem((ItemStack)mainRepresentation);
            for (ItemStack extraRepresentation : extraRepresentations) {
                ItemStack output = recipe.getOutput(mainRepresentation, extraRepresentation);
                if (output.func_190926_b()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssMain, mainRepresentation.func_190916_E());
                ingredientHelper.put(extraRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

