/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public class TransporterStack {
    public ItemStack itemStack = ItemStack.field_190927_a;
    public int progress;
    public EnumColor color = null;
    public boolean initiatedPath = false;
    public Direction idleDir = null;
    public Coord4D originalLocation;
    public Coord4D homeLocation;
    private Coord4D clientNext;
    private Coord4D clientPrev;
    private Path pathType;
    private List<Coord4D> pathToTarget = new ArrayList<Coord4D>();

    public static TransporterStack readFromNBT(CompoundNBT nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.read(nbtTags);
        return stack;
    }

    public static TransporterStack readFromUpdate(CompoundNBT nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.readFromUpdateTag(nbtTags);
        return stack;
    }

    public static TransporterStack readFromPacket(PacketBuffer dataStream) {
        TransporterStack stack = new TransporterStack();
        stack.read(dataStream);
        if (stack.progress == 0) {
            stack.progress = 5;
        }
        return stack;
    }

    public void write(ILogisticalTransporter transporter, PacketBuffer buf) {
        buf.func_150787_b(TransporterUtils.getColorIndex(this.color));
        buf.func_150787_b(this.progress);
        this.originalLocation.write(buf);
        buf.func_179249_a((Enum)this.pathType);
        if (this.pathToTarget.indexOf(transporter.coord()) > 0) {
            buf.writeBoolean(true);
            this.getNext(transporter).write(buf);
        } else {
            buf.writeBoolean(false);
        }
        this.getPrev(transporter).write(buf);
        buf.func_150788_a(this.itemStack);
    }

    public void read(PacketBuffer dataStream) {
        this.color = TransporterUtils.readColor(dataStream.func_150792_a());
        this.progress = dataStream.func_150792_a();
        this.originalLocation = Coord4D.read(dataStream);
        this.pathType = (Path)dataStream.func_179257_a(Path.class);
        if (dataStream.readBoolean()) {
            this.clientNext = Coord4D.read(dataStream);
        }
        this.clientPrev = Coord4D.read(dataStream);
        this.itemStack = dataStream.func_150791_c();
    }

    public void writeToUpdateTag(ILogisticalTransporter transporter, CompoundNBT updateTag) {
        updateTag.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        updateTag.func_74768_a("progress", this.progress);
        updateTag.func_218657_a("originalLocation", (INBT)this.originalLocation.write(new CompoundNBT()));
        updateTag.func_74768_a("pathType", this.pathType.ordinal());
        if (this.pathToTarget.indexOf(transporter.coord()) > 0) {
            updateTag.func_218657_a("clientNext", (INBT)this.getNext(transporter).write(new CompoundNBT()));
        }
        updateTag.func_218657_a("clientPrevious", (INBT)this.getPrev(transporter).write(new CompoundNBT()));
        this.itemStack.func_77955_b(updateTag);
    }

    public void readFromUpdateTag(CompoundNBT updateTag) {
        NBTUtils.setEnumIfPresent(updateTag, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        this.progress = updateTag.func_74762_e("progress");
        NBTUtils.setCoord4DIfPresent(updateTag, "originalLocation", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(updateTag, "pathType", Path::byIndexStatic, type -> {
            this.pathType = type;
        });
        NBTUtils.setCoord4DIfPresent(updateTag, "clientNext", coord -> {
            this.clientNext = coord;
        });
        NBTUtils.setCoord4DIfPresent(updateTag, "clientPrevious", coord -> {
            this.clientPrev = coord;
        });
        this.itemStack = ItemStack.func_199557_a((CompoundNBT)updateTag);
    }

    public void write(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.color));
        nbtTags.func_74768_a("progress", this.progress);
        nbtTags.func_218657_a("originalLocation", (INBT)this.originalLocation.write(new CompoundNBT()));
        if (this.idleDir != null) {
            nbtTags.func_74768_a("idleDir", this.idleDir.ordinal());
        }
        if (this.homeLocation != null) {
            nbtTags.func_218657_a("homeLocation", (INBT)this.homeLocation.write(new CompoundNBT()));
        }
        nbtTags.func_74768_a("pathType", this.pathType.ordinal());
        this.itemStack.func_77955_b(nbtTags);
    }

    public void read(CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        this.progress = nbtTags.func_74762_e("progress");
        NBTUtils.setCoord4DIfPresent(nbtTags, "originalLocation", coord -> {
            this.originalLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "idleDir", Direction::func_82600_a, dir -> {
            this.idleDir = dir;
        });
        NBTUtils.setCoord4DIfPresent(nbtTags, "homeLocation", coord -> {
            this.homeLocation = coord;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "pathType", Path::byIndexStatic, type -> {
            this.pathType = type;
        });
        this.itemStack = ItemStack.func_199557_a((CompoundNBT)nbtTags);
    }

    public void setPath(List<Coord4D> path, Path type) {
        if (this.pathType != Path.NONE) {
            TransporterManager.remove(this);
        }
        this.pathToTarget = path;
        this.pathType = type;
        if (this.pathType != Path.NONE) {
            TransporterManager.add(this);
        }
    }

    public boolean hasPath() {
        return this.pathToTarget != null && this.pathToTarget.size() >= 2;
    }

    public List<Coord4D> getPath() {
        return this.pathToTarget;
    }

    public Path getPathType() {
        return this.pathType;
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, ILogisticalTransporter transporter, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewBasePath(transporter, this, request, min);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(newPath.getPath(), Path.DEST);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, TileEntityLogisticalSorter outputter, ILogisticalTransporter transporter, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewRRPath(transporter, this, request, outputter, min);
        if (newPath == null) {
            return request.getEmptyResponse();
        }
        this.idleDir = null;
        this.setPath(newPath.getPath(), Path.DEST);
        this.initiatedPath = true;
        return newPath.getResponse();
    }

    public boolean calculateIdle(ILogisticalTransporter transporter) {
        Pair<List<Coord4D>, Path> newPath = TransporterPathfinder.getIdlePath(transporter, this);
        if (newPath == null) {
            return false;
        }
        if (newPath.getRight() == Path.HOME) {
            this.idleDir = null;
        }
        this.setPath((List)newPath.getLeft(), (Path)((Object)newPath.getRight()));
        this.originalLocation = transporter.coord();
        this.initiatedPath = true;
        return true;
    }

    public boolean isFinal(ILogisticalTransporter transporter) {
        return this.pathToTarget.indexOf(transporter.coord()) == (this.pathType == Path.NONE ? 0 : 1);
    }

    public Coord4D getNext(ILogisticalTransporter transporter) {
        if (!transporter.world().field_72995_K) {
            int index = this.pathToTarget.indexOf(transporter.coord()) - 1;
            if (index < 0) {
                return null;
            }
            return this.pathToTarget.get(index);
        }
        return this.clientNext;
    }

    public Coord4D getPrev(ILogisticalTransporter transporter) {
        if (!transporter.world().field_72995_K) {
            int index = this.pathToTarget.indexOf(transporter.coord()) + 1;
            if (index < this.pathToTarget.size()) {
                return this.pathToTarget.get(index);
            }
            return this.originalLocation;
        }
        return this.clientPrev;
    }

    public Direction getSide(ILogisticalTransporter transporter) {
        Direction side = null;
        if (this.progress < 50) {
            Coord4D prev = this.getPrev(transporter);
            if (prev != null) {
                side = transporter.coord().sideDifference(prev);
            }
        } else {
            Coord4D next = this.getNext(transporter);
            if (next != null) {
                side = next.sideDifference(transporter.coord());
            }
        }
        return side == null ? Direction.DOWN : side;
    }

    public boolean canInsertToTransporter(TileEntity tile, Direction from, @Nullable TileEntity tileFrom) {
        Optional<IBlockableConnection> blockableConnection;
        ILogisticalTransporter transporter;
        Direction opposite = from.func_176734_d();
        Optional<ILogisticalTransporter> transporterCap = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, opposite));
        if (transporterCap.isPresent() && ((transporter = transporterCap.get()).getColor() == null || transporter.getColor() == this.color) && (blockableConnection = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, opposite))).isPresent()) {
            return blockableConnection.get().canConnectMutual(opposite, tileFrom);
        }
        return false;
    }

    public boolean canInsertToTransporter(ILogisticalTransporter transporter, Direction side, @Nullable TileEntity tileFrom) {
        return (transporter.getColor() == this.color || transporter.getColor() == null) && transporter.canConnectMutual(side, tileFrom);
    }

    public Coord4D getDest() {
        return this.pathToTarget.get(0);
    }

    public static enum Path {
        DEST,
        HOME,
        NONE;

        private static final Path[] PATHS;

        public static Path byIndexStatic(int index) {
            return MathUtils.getByIndexMod(PATHS, index);
        }

        static {
            PATHS = Path.values();
        }
    }
}

