/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.network.BasePacketHandler;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class MModIDFilter
extends MinerFilter<MModIDFilter>
implements IModIDFilter<MModIDFilter> {
    private String modID;

    @Override
    public boolean canFilter(BlockState state) {
        String id = state.func_177230_c().getRegistryName().func_110624_b();
        if (this.modID.equals(id) || this.modID.equals("*")) {
            return true;
        }
        if (this.modID.endsWith("*") && !this.modID.startsWith("*")) {
            return id.startsWith(this.modID.substring(0, this.modID.length() - 1));
        }
        if (this.modID.startsWith("*") && !this.modID.endsWith("*")) {
            return id.endsWith(this.modID.substring(1));
        }
        if (this.modID.startsWith("*") && this.modID.endsWith("*")) {
            return id.contains(this.modID.substring(1, this.modID.length() - 1));
        }
        return false;
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74778_a("modID", this.modID);
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        super.read(nbtTags);
        this.modID = nbtTags.func_74779_i("modID");
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.func_180714_a(this.modID);
    }

    @Override
    public void read(PacketBuffer dataStream) {
        super.read(dataStream);
        this.modID = BasePacketHandler.readString(dataStream);
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + this.modID.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object filter) {
        return filter instanceof MModIDFilter && ((MModIDFilter)filter).modID.equals(this.modID);
    }

    @Override
    public MModIDFilter clone() {
        MModIDFilter filter = new MModIDFilter();
        filter.replaceStack = this.replaceStack;
        filter.requireStack = this.requireStack;
        filter.modID = this.modID;
        return filter;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_MODID_FILTER;
    }

    @Override
    public void setModID(String id) {
        this.modID = id;
    }

    @Override
    public String getModID() {
        return this.modID;
    }
}

