/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.multiblock.UpdateProtocol;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class BoilerUpdateProtocol
extends UpdateProtocol<SynchronizedBoilerData> {
    public static final int WATER_PER_TANK = 16000;
    public static final long STEAM_PER_TANK = 160000L;

    public BoilerUpdateProtocol(TileEntityBoilerCasing tile) {
        super(tile);
    }

    @Override
    protected UpdateProtocol.CasingType getCasingType(BlockPos pos) {
        Block block = this.pointer.func_145831_w().func_180495_p(pos).func_177230_c();
        if (BlockTypeTile.is(block, MekanismBlockTypes.BOILER_CASING)) {
            return UpdateProtocol.CasingType.FRAME;
        }
        if (BlockTypeTile.is(block, MekanismBlockTypes.BOILER_VALVE)) {
            return UpdateProtocol.CasingType.VALVE;
        }
        return UpdateProtocol.CasingType.INVALID;
    }

    @Override
    protected boolean isValidInnerNode(BlockPos pos) {
        if (super.isValidInnerNode(pos)) {
            return true;
        }
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.pointer.func_145831_w(), pos);
        return tile instanceof TileEntityPressureDisperser || tile instanceof TileEntitySuperheatingElement;
    }

    @Override
    protected boolean canForm(SynchronizedBoilerData structure) {
        if (structure.volHeight < 3) {
            return false;
        }
        ObjectOpenHashSet dispersers = new ObjectOpenHashSet();
        ObjectOpenHashSet elements = new ObjectOpenHashSet();
        for (Coord4D coord : this.innerNodes) {
            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)this.pointer.func_145831_w(), coord.getPos());
            if (tile instanceof TileEntityPressureDisperser) {
                dispersers.add(coord);
                continue;
            }
            if (!(tile instanceof TileEntitySuperheatingElement)) continue;
            structure.internalLocations.add(coord);
            elements.add(coord);
        }
        if (dispersers.isEmpty()) {
            return false;
        }
        final Coord4D initDisperser = (Coord4D)dispersers.iterator().next();
        BlockPos pos = new BlockPos(structure.renderLocation.x, initDisperser.y, structure.renderLocation.z);
        for (int x = 1; x < structure.volLength - 1; ++x) {
            for (int z = 1; z < structure.volWidth - 1; ++z) {
                BlockPos shifted = pos.func_177982_a(x, 0, z);
                TileEntityPressureDisperser tile = MekanismUtils.getTileEntity(TileEntityPressureDisperser.class, (IBlockReader)this.pointer.func_145831_w(), shifted);
                if (tile == null) {
                    return false;
                }
                dispersers.remove(new Coord4D(shifted, (IWorldReader)this.pointer.func_145831_w()));
            }
        }
        if (!dispersers.isEmpty()) {
            return false;
        }
        if (!elements.isEmpty()) {
            structure.superheatingElements = new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

                @Override
                public boolean isValid(Coord4D coord) {
                    return MekanismUtils.getTileEntity(TileEntitySuperheatingElement.class, (IBlockReader)BoilerUpdateProtocol.this.pointer.func_145831_w(), coord.getPos()) != null;
                }
            }).calculate((Coord4D)elements.iterator().next());
        }
        if (elements.size() > structure.superheatingElements) {
            return false;
        }
        Coord4D initAir = null;
        int totalAir = 0;
        for (int x = structure.renderLocation.x; x < structure.renderLocation.x + structure.volLength; ++x) {
            for (int y = structure.renderLocation.y; y < initDisperser.y; ++y) {
                for (int z = structure.renderLocation.z; z < structure.renderLocation.z + structure.volWidth; ++z) {
                    if (!this.pointer.func_145831_w().func_175623_d(new BlockPos(x, y, z)) && !this.isViableNode(x, y, z)) continue;
                    initAir = new Coord4D(x, y, z, this.pointer.func_145831_w().func_201675_m().func_186058_p());
                    ++totalAir;
                }
            }
        }
        if (initAir == null) {
            return false;
        }
        final Coord4D renderLocation = structure.renderLocation;
        final int volLength = structure.volLength;
        final int volWidth = structure.volWidth;
        structure.setWaterVolume(new UpdateProtocol.NodeCounter(new UpdateProtocol.NodeChecker(){

            @Override
            public final boolean isValid(Coord4D coord) {
                BlockPos coordPos = coord.getPos();
                int x = coordPos.func_177958_n();
                int y = coordPos.func_177956_o();
                int z = coordPos.func_177952_p();
                return y >= renderLocation.y - 1 && y < initDisperser.y && x >= renderLocation.x && x < renderLocation.x + volLength && z >= renderLocation.z && z < renderLocation.z + volWidth && (BoilerUpdateProtocol.this.pointer.func_145831_w().func_175623_d(coordPos) || BoilerUpdateProtocol.this.isViableNode(coordPos));
            }
        }).calculate(initAir));
        if (totalAir > structure.getWaterVolume()) {
            return false;
        }
        int steamHeight = structure.renderLocation.y + structure.volHeight - 2 - initDisperser.y;
        structure.setSteamVolume((long)structure.volWidth * (long)structure.volLength * (long)steamHeight);
        structure.upperRenderLocation = new Coord4D(structure.renderLocation.x, initDisperser.y + 1, structure.renderLocation.z, this.pointer.func_145831_w().func_201675_m().func_186058_p());
        return true;
    }

    protected BoilerCache getNewCache() {
        return new BoilerCache();
    }

    @Override
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData((TileEntityBoilerCasing)this.pointer);
    }

    @Override
    protected MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    @Override
    protected void mergeCaches(List<ItemStack> rejectedItems, MultiblockCache<SynchronizedBoilerData> cache, MultiblockCache<SynchronizedBoilerData> merge) {
        BoilerCache boilerCache = (BoilerCache)cache;
        BoilerCache mergeCache = (BoilerCache)merge;
        StorageUtils.mergeTanks(boilerCache.getFluidTanks(null).get(0), mergeCache.getFluidTanks(null).get(0));
        StorageUtils.mergeTanks(boilerCache.getGasTanks(null).get(0), mergeCache.getGasTanks(null).get(0));
        StorageUtils.mergeContainers(boilerCache.getHeatCapacitors(null).get(0), mergeCache.getHeatCapacitors(null).get(0));
    }

    @Override
    protected void onFormed() {
        super.onFormed();
        if (!((SynchronizedBoilerData)this.structureFound).waterTank.isEmpty()) {
            ((SynchronizedBoilerData)this.structureFound).waterTank.setStackSize(Math.min(((SynchronizedBoilerData)this.structureFound).waterTank.getFluidAmount(), ((SynchronizedBoilerData)this.structureFound).getWaterTankCapacity()), Action.EXECUTE);
        }
        if (!((SynchronizedBoilerData)this.structureFound).steamTank.isEmpty()) {
            ((SynchronizedBoilerData)this.structureFound).steamTank.setStackSize(Math.min(((SynchronizedBoilerData)this.structureFound).steamTank.getStored(), ((SynchronizedBoilerData)this.structureFound).getSteamTankCapacity()), Action.EXECUTE);
        }
    }
}

