/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.blocktype;

import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import mekanism.api.Pos3D;
import mekanism.api.Upgrade;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.AttributeFactoryType;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.AttributeUpgradeable;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;

public class Machine<TILE extends TileEntityMekanism>
extends BlockTypeTile<TILE> {
    public Machine(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, MekanismLang description) {
        super(tileEntityRegistrar, description);
        this.add(new AttributeParticleFX().add((IParticleData)ParticleTypes.field_197601_L, (Random rand) -> new Pos3D(rand.nextFloat() * 0.6f - 0.3f, rand.nextFloat() * 6.0f / 16.0f, 0.52)).add((IParticleData)RedstoneParticleData.field_197564_a, (Random rand) -> new Pos3D(rand.nextFloat() * 0.6f - 0.3f, rand.nextFloat() * 6.0f / 16.0f, 0.52)));
        this.add(new AttributeStateActive(), new AttributeStateFacing(), new Attributes.AttributeInventory(), new Attributes.AttributeSecurity(), new Attributes.AttributeRedstone(), new Attributes.AttributeComparator());
        this.add(new AttributeUpgradeSupport(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING)));
    }

    public static class MachineBuilder<MACHINE extends Machine<TILE>, TILE extends TileEntityMekanism, T extends MachineBuilder<MACHINE, TILE, T>>
    extends BlockTypeTile.BlockTileBuilder<MACHINE, TILE, T> {
        protected MachineBuilder(MACHINE holder) {
            super(holder);
        }

        public static <TILE extends TileEntityMekanism> MachineBuilder<Machine<TILE>, TILE, ?> createMachine(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, MekanismLang description) {
            return new MachineBuilder(new Machine<TILE>(tileEntityRegistrar, description));
        }

        public static <TILE extends TileEntityMekanism> MachineBuilder<FactoryMachine<TILE>, TILE, ?> createFactoryMachine(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, MekanismLang description, FactoryType factoryType) {
            return new MachineBuilder(new FactoryMachine<TILE>(tileEntityRegistrar, description, factoryType));
        }

        public T withSupportedUpgrades(Set<Upgrade> upgrades) {
            ((Machine)this.holder).add(new AttributeUpgradeSupport(upgrades));
            return (T)((MachineBuilder)this.getThis());
        }
    }

    public static class FactoryMachine<TILE extends TileEntityMekanism>
    extends Machine<TILE> {
        public FactoryMachine(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntitySupplier, MekanismLang description, FactoryType factoryType) {
            super(tileEntitySupplier, description);
            this.add(new AttributeFactoryType(factoryType), new AttributeUpgradeable(() -> MekanismBlocks.getFactory(FactoryTier.BASIC, this.get(AttributeFactoryType.class).getFactoryType())));
        }
    }
}

