/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.slot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import net.minecraft.util.Direction;

public class InventorySlotHolder
implements IInventorySlotHolder {
    private final Map<RelativeSide, List<IInventorySlot>> directionalSlots = new EnumMap<RelativeSide, List<IInventorySlot>>(RelativeSide.class);
    private final List<IInventorySlot> inventorySlots = new ArrayList<IInventorySlot>();
    private final Supplier<Direction> facingSupplier;
    private final Predicate<RelativeSide> insertPredicate;
    private final Predicate<RelativeSide> extractPredicate;

    InventorySlotHolder(Supplier<Direction> facingSupplier, Predicate<RelativeSide> insertPredicate, Predicate<RelativeSide> extractPredicate) {
        this.facingSupplier = facingSupplier;
        this.insertPredicate = insertPredicate;
        this.extractPredicate = extractPredicate;
    }

    void addSlot(@Nonnull IInventorySlot slot, RelativeSide ... sides) {
        this.inventorySlots.add(slot);
        for (RelativeSide side : sides) {
            this.directionalSlots.computeIfAbsent(side, k -> new ArrayList()).add(slot);
        }
    }

    @Override
    @Nonnull
    public List<IInventorySlot> getInventorySlots(@Nullable Direction direction) {
        if (direction == null || this.directionalSlots.isEmpty()) {
            return this.inventorySlots;
        }
        RelativeSide side = RelativeSide.fromDirections(this.facingSupplier.get(), direction);
        List<IInventorySlot> slots = this.directionalSlots.get((Object)side);
        if (slots == null) {
            return Collections.emptyList();
        }
        return slots;
    }

    @Override
    public boolean canInsert(@Nullable Direction direction) {
        return direction != null && this.insertPredicate.test(RelativeSide.fromDirections(this.facingSupplier.get(), direction));
    }

    @Override
    public boolean canExtract(@Nullable Direction direction) {
        return direction != null && this.extractPredicate.test(RelativeSide.fromDirections(this.facingSupplier.get(), direction));
    }
}

