/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.heat;

import java.util.Objects;
import java.util.function.DoubleSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.base.TileEntityUpdateable;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockHeatCapacitor<MULTIBLOCK extends TileEntityMultiblock<?>>
extends VariableHeatCapacitor {
    private final MULTIBLOCK multiblock;

    public static <MULTIBLOCK extends TileEntityMultiblock<?>> MultiblockHeatCapacitor<MULTIBLOCK> create(MULTIBLOCK multiblock, double heatCapacity) {
        return MultiblockHeatCapacitor.create(multiblock, heatCapacity, () -> 1.0, () -> 0.0);
    }

    public static <MULTIBLOCK extends TileEntityMultiblock<?>> MultiblockHeatCapacitor<MULTIBLOCK> create(MULTIBLOCK multiblock, double heatCapacity, DoubleSupplier conductionCoefficient, DoubleSupplier insulationCoefficient) {
        Objects.requireNonNull(conductionCoefficient, "Conduction coefficient supplier cannot be null");
        Objects.requireNonNull(insulationCoefficient, "Insulation coefficient supplier cannot be null");
        return new MultiblockHeatCapacitor<MULTIBLOCK>(multiblock, heatCapacity, conductionCoefficient, insulationCoefficient);
    }

    protected MultiblockHeatCapacitor(MULTIBLOCK multiblock, double heatCapacity, DoubleSupplier conductionCoefficient, DoubleSupplier insulationCoefficient) {
        super(heatCapacity, conductionCoefficient, insulationCoefficient, null);
        this.multiblock = multiblock;
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.multiblock.func_145830_o() && !((TileEntityUpdateable)((Object)this.multiblock)).isRemote() && ((TileEntityMultiblock)this.multiblock).isRendering) {
            ((TileEntityUpdateable)((Object)this.multiblock)).markDirty(false);
        }
    }
}

