/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.block.IColoredBlock;
import mekanism.api.inventory.AutomationType;
import mekanism.api.text.EnumColor;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.machine.prefab.BlockTile;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockFluidTank
extends BlockTile.BlockTileModel<TileEntityFluidTank, Machine<TileEntityFluidTank>>
implements IColoredBlock {
    public BlockFluidTank(Machine<TileEntityFluidTank> type) {
        super(type, Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.5f, 16.0f));
    }

    @Override
    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        int ambientLight = 0;
        TileEntityFluidTank tile = MekanismUtils.getTileEntity(TileEntityFluidTank.class, world, pos);
        if (tile != null) {
            FluidStack fluid;
            if (MekanismConfig.client.enableAmbientLighting.get() && tile.lightUpdate() && tile.getActive()) {
                ambientLight = MekanismConfig.client.ambientLightingLevel.get();
            }
            if (!(fluid = tile.fluidTank.getFluid()).isEmpty()) {
                FluidAttributes fluidAttributes = fluid.getFluid().getAttributes();
                ambientLight = Math.max(ambientLight, world instanceof ILightReader ? fluidAttributes.getLuminosity((ILightReader)world, pos) : fluidAttributes.getLuminosity(fluid));
            }
        }
        return ambientLight;
    }

    @Override
    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntityFluidTank tile = MekanismUtils.getTileEntity(TileEntityFluidTank.class, (IBlockReader)world, pos, true);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        if (tile.tryWrench(state, player, hand, hit) != WrenchResult.PASS) {
            return ActionResultType.SUCCESS;
        }
        if (!player.func_225608_bj_()) {
            if (SecurityUtils.canAccess(player, tile)) {
                ItemStack stack = player.func_184586_b(hand);
                if (!stack.func_190926_b() && this.manageInventory(player, tile, hand, stack)) {
                    player.field_71071_by.func_70296_d();
                    return ActionResultType.SUCCESS;
                }
            } else {
                SecurityUtils.displayNoAccess(player);
                return ActionResultType.SUCCESS;
            }
        }
        return tile.openGui(player);
    }

    private boolean manageInventory(PlayerEntity player, TileEntityFluidTank tile, Hand hand, ItemStack itemStack) {
        ItemStack copyStack = StackUtils.size(itemStack, 1);
        Optional fluidHandlerItem = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)copyStack));
        if (fluidHandlerItem.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerItem.get();
            FluidStack fluidInItem = tile.fluidTank.isEmpty() ? handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) : handler.drain(new FluidStack(tile.fluidTank.getFluid(), Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE);
            if (fluidInItem.isEmpty()) {
                if (!tile.fluidTank.isEmpty()) {
                    int filled = handler.fill(tile.fluidTank.getFluid(), player.func_184812_l_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = handler.getContainer();
                    if (filled > 0) {
                        if (itemStack.func_190916_E() == 1) {
                            player.func_184611_a(hand, container);
                        } else if (itemStack.func_190916_E() > 1 && player.field_71071_by.func_70441_a(container)) {
                            itemStack.func_190918_g(1);
                        } else {
                            player.func_146097_a(container, false, true);
                            itemStack.func_190918_g(1);
                        }
                        tile.fluidTank.extract(filled, Action.EXECUTE, AutomationType.MANUAL);
                        return true;
                    }
                }
            } else {
                int storedAmount;
                FluidStack simulatedRemainder = tile.fluidTank.insert(fluidInItem, Action.SIMULATE, AutomationType.MANUAL);
                int remainder = simulatedRemainder.getAmount();
                if (remainder < (storedAmount = fluidInItem.getAmount())) {
                    boolean filled = false;
                    FluidStack drained = handler.drain(new FluidStack(fluidInItem, storedAmount - remainder), player.func_184812_l_() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                    if (!drained.isEmpty()) {
                        ItemStack container = handler.getContainer();
                        if (player.func_184812_l_()) {
                            filled = true;
                        } else if (!container.func_190926_b()) {
                            if (container.func_190916_E() == 1) {
                                player.func_184611_a(hand, container);
                                filled = true;
                            } else if (player.field_71071_by.func_70441_a(container)) {
                                itemStack.func_190918_g(1);
                                filled = true;
                            }
                        } else {
                            itemStack.func_190918_g(1);
                            if (itemStack.func_190926_b()) {
                                player.func_184611_a(hand, ItemStack.field_190927_a);
                            }
                            filled = true;
                        }
                        if (filled) {
                            tile.fluidTank.insert(drained, Action.EXECUTE, AutomationType.MANUAL);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public EnumColor getColor() {
        return Attribute.getBaseTier(this).getColor();
    }
}

