/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import mekanism.common.Mekanism;
import mekanism.common.chunkloading.ChunkManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.world.GenHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonWorldTickHandler {
    private static final long maximumDeltaTimeNanoSecs = 16000000L;
    private Map<ResourceLocation, Queue<ChunkPos>> chunkRegenMap;

    public void addRegenChunk(DimensionType dimension, ChunkPos chunkCoord) {
        ResourceLocation dimensionName;
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new Object2ObjectArrayMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionName = dimension.getRegistryName())) {
            LinkedList<ChunkPos> list = new LinkedList<ChunkPos>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionName, list);
        } else if (!this.chunkRegenMap.get(dimensionName).contains(chunkCoord)) {
            this.chunkRegenMap.get(dimensionName).add(chunkCoord);
        }
    }

    public void resetRegenChunks() {
        if (this.chunkRegenMap != null) {
            this.chunkRegenMap.clear();
        }
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            if (!FrequencyManager.loaded) {
                FrequencyManager.load();
            }
            if (event.getWorld() instanceof ServerWorld) {
                ChunkManager.worldLoad((ServerWorld)event.getWorld());
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            this.tickEnd(event.world);
        }
    }

    public void tickEnd(World world) {
        if (!world.field_72995_K) {
            MultiblockManager.tick(world);
            FrequencyManager.tick(world);
            ChunkManager.tick((ServerWorld)world);
            if (this.chunkRegenMap == null || !MekanismConfig.world.enableRegeneration.get()) {
                return;
            }
            ResourceLocation dimensionName = world.func_201675_m().func_186058_p().getRegistryName();
            if (this.chunkRegenMap.containsKey(dimensionName)) {
                ChunkPos nextChunk;
                Queue<ChunkPos> chunksToGen = this.chunkRegenMap.get(dimensionName);
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                    Random fmlRandom = new Random(world.func_72905_C());
                    long xSeed = fmlRandom.nextLong() >> 3;
                    long zSeed = fmlRandom.nextLong() >> 3;
                    fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ world.func_72905_C());
                    if (!GenHandler.generate((ServerWorld)world, fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b)) continue;
                    Mekanism.logger.info("Regenerating ores at chunk " + nextChunk);
                }
                if (chunksToGen.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionName);
                }
            }
        }
    }
}

