/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class RenderMechanicalPipe
extends RenderTransmitterBase<TileEntityMechanicalPipe> {
    private static final int stages = 100;
    private static final double height = 0.45;
    private static final double offset = 0.015;
    private static Int2ObjectMap<FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>>> cachedLiquids = new Int2ObjectArrayMap(7);

    public RenderMechanicalPipe(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    public static void onStitch() {
        cachedLiquids.clear();
    }

    @Override
    protected void render(TileEntityMechanicalPipe pipe, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        TransmitterImpl transmitter = pipe.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)transmitter.getTransmitterNetwork();
            if (!network.lastFluid.isEmpty() && !network.fluidTank.isEmpty() && network.fluidScale > 0.0f) {
                FluidStack fluidStack = network.lastFluid;
                float fluidScale = network.fluidScale;
                int stage = fluidStack.getFluid().getAttributes().isGaseous(fluidStack) ? 99 : Math.max(3, (int)(fluidScale * 99.0f));
                int glow = MekanismRenderer.calculateGlowLight(light, fluidStack);
                int color = MekanismRenderer.getColorARGB(fluidStack, fluidScale);
                ArrayList<String> connectionContents = new ArrayList<String>();
                MekanismRenderer.Model3D model = this.getModel(null, fluidStack, stage);
                IVertexBuilder buffer = renderer.getBuffer(MekanismRenderType.resizableCuboid());
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TileEntitySidedPipe.ConnectionType connectionType = pipe.getConnectionType(side);
                    if (connectionType == TileEntitySidedPipe.ConnectionType.NORMAL) {
                        MekanismRenderer.renderObject(this.getModel(side, fluidStack, stage), matrix, buffer, color, glow);
                    } else if (connectionType != TileEntitySidedPipe.ConnectionType.NONE) {
                        connectionContents.add(side.func_176610_l() + connectionType.func_176610_l().toUpperCase());
                    }
                    if (model == null) continue;
                    model.setSideRender(side, connectionType == TileEntitySidedPipe.ConnectionType.NONE);
                }
                MekanismRenderer.renderObject(model, matrix, buffer, MekanismRenderer.getColorARGB(fluidStack, fluidScale), glow);
                if (!connectionContents.isEmpty()) {
                    matrix.func_227860_a_();
                    matrix.func_227861_a_(0.5, 0.5, 0.5);
                    this.renderModel(pipe, matrix, renderer.getBuffer(MekanismRenderType.transmitterContents(AtlasTexture.field_110575_b)), MekanismRenderer.getRed(color), MekanismRenderer.getGreen(color), MekanismRenderer.getBlue(color), MekanismRenderer.getAlpha(color), glow, overlayLight, MekanismRenderer.getFluidTexture(fluidStack, MekanismRenderer.FluidType.STILL), connectionContents);
                    matrix.func_227865_b_();
                }
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "mechanicalPipe";
    }

    @Nullable
    private MekanismRenderer.Model3D getModel(@Nullable Direction side, FluidStack fluid, int stage) {
        FluidRenderMap cachedFluids;
        int sideOrdinal;
        if (fluid.isEmpty()) {
            return null;
        }
        int n = sideOrdinal = side == null ? 6 : side.ordinal();
        if (cachedLiquids.containsKey(sideOrdinal)) {
            cachedFluids = (FluidRenderMap)((Object)cachedLiquids.get(sideOrdinal));
            if (cachedFluids.containsKey(fluid) && ((Int2ObjectMap)cachedFluids.get(fluid)).containsKey(stage)) {
                return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedFluids.get(fluid)).get(stage);
            }
        } else {
            cachedFluids = new FluidRenderMap();
            cachedLiquids.put(sideOrdinal, cachedFluids);
        }
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        if (side != null) {
            model.setSideRender(side, false);
            model.setSideRender(side.func_176734_d(), false);
        }
        double stageRatio = (double)stage / 100.0 * 0.45;
        switch (sideOrdinal) {
            case 0: {
                model.minX = 0.5 - stageRatio / 2.0;
                model.minY = 0.0;
                model.minZ = 0.5 - stageRatio / 2.0;
                model.maxX = 0.5 + stageRatio / 2.0;
                model.maxY = 0.265;
                model.maxZ = 0.5 + stageRatio / 2.0;
                break;
            }
            case 1: {
                model.minX = 0.5 - stageRatio / 2.0;
                model.minY = 0.235 + stageRatio;
                model.minZ = 0.5 - stageRatio / 2.0;
                model.maxX = 0.5 + stageRatio / 2.0;
                model.maxY = 1.0;
                model.maxZ = 0.5 + stageRatio / 2.0;
                break;
            }
            case 2: {
                model.minX = 0.265;
                model.minY = 0.265;
                model.minZ = 0.0;
                model.maxX = 0.735;
                model.maxY = 0.265 + stageRatio;
                model.maxZ = 0.265;
                break;
            }
            case 3: {
                model.minX = 0.265;
                model.minY = 0.265;
                model.minZ = 0.735;
                model.maxX = 0.735;
                model.maxY = 0.265 + stageRatio;
                model.maxZ = 1.0;
                break;
            }
            case 4: {
                model.minX = 0.0;
                model.minY = 0.265;
                model.minZ = 0.265;
                model.maxX = 0.265;
                model.maxY = 0.265 + stageRatio;
                model.maxZ = 0.735;
                break;
            }
            case 5: {
                model.minX = 0.735;
                model.minY = 0.265;
                model.minZ = 0.265;
                model.maxX = 1.0;
                model.maxY = 0.265 + stageRatio;
                model.maxZ = 0.735;
                break;
            }
            case 6: {
                model.minX = 0.265;
                model.minY = 0.265;
                model.minZ = 0.265;
                model.maxX = 0.735;
                model.maxY = 0.265 + stageRatio;
                model.maxZ = 0.735;
            }
        }
        if (cachedFluids.containsKey(fluid)) {
            ((Int2ObjectMap)cachedFluids.get(fluid)).put(stage, (Object)model);
        } else {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
            map.put(stage, (Object)model);
            cachedFluids.put(fluid, map);
        }
        return model;
    }
}

