/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.GasRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.tile.TileEntityBoilerCasing;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.BlockPos;

@ParametersAreNonnullByDefault
public class RenderThermoelectricBoiler
extends MekanismTileEntityRenderer<TileEntityBoilerCasing> {
    public RenderThermoelectricBoiler(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityBoilerCasing tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.clientHasStructure && tile.isRendering && tile.structure != null && ((SynchronizedBoilerData)tile.structure).renderLocation != null && ((SynchronizedBoilerData)tile.structure).upperRenderLocation != null) {
            RenderData data;
            BlockPos pos = tile.func_174877_v();
            IVertexBuilder buffer = null;
            if (!((SynchronizedBoilerData)tile.structure).waterTank.isEmpty()) {
                data = new FluidRenderData();
                ((FluidRenderData)data).height = ((SynchronizedBoilerData)tile.structure).upperRenderLocation.y - 1 - ((SynchronizedBoilerData)tile.structure).renderLocation.y;
                if (((FluidRenderData)data).height >= 1) {
                    ((FluidRenderData)data).location = ((SynchronizedBoilerData)tile.structure).renderLocation;
                    ((FluidRenderData)data).length = ((SynchronizedBoilerData)tile.structure).volLength;
                    ((FluidRenderData)data).width = ((SynchronizedBoilerData)tile.structure).volWidth;
                    ((FluidRenderData)data).fluidType = ((SynchronizedBoilerData)tile.structure).waterTank.getFluid();
                    int glow = ((FluidRenderData)data).calculateGlowLight(light);
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)(((FluidRenderData)data).location.x - pos.func_177958_n()), (double)(((FluidRenderData)data).location.y - pos.func_177956_o()), (double)(((FluidRenderData)data).location.z - pos.func_177952_p()));
                    buffer = renderer.getBuffer(MekanismRenderType.resizableCuboid());
                    MekanismRenderer.renderObject(ModelRenderer.getModel(data, tile.prevWaterScale), matrix, buffer, ((FluidRenderData)data).getColorARGB(tile.prevWaterScale), glow);
                    matrix.func_227865_b_();
                    MekanismRenderer.renderValves(matrix, buffer, ((SynchronizedBoilerData)tile.structure).valves, (FluidRenderData)data, pos, glow);
                }
            }
            if (!((SynchronizedBoilerData)tile.structure).steamTank.isEmpty()) {
                data = new GasRenderData();
                ((GasRenderData)data).height = ((SynchronizedBoilerData)tile.structure).renderLocation.y + ((SynchronizedBoilerData)tile.structure).volHeight - 2 - ((SynchronizedBoilerData)tile.structure).upperRenderLocation.y;
                if (((GasRenderData)data).height >= 1) {
                    ((GasRenderData)data).location = ((SynchronizedBoilerData)tile.structure).upperRenderLocation;
                    ((GasRenderData)data).length = ((SynchronizedBoilerData)tile.structure).volLength;
                    ((GasRenderData)data).width = ((SynchronizedBoilerData)tile.structure).volWidth;
                    ((GasRenderData)data).gasType = (GasStack)((SynchronizedBoilerData)tile.structure).steamTank.getStack();
                    if (buffer == null) {
                        buffer = renderer.getBuffer(MekanismRenderType.resizableCuboid());
                    }
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)(((GasRenderData)data).location.x - pos.func_177958_n()), (double)(((GasRenderData)data).location.y - pos.func_177956_o()), (double)(((GasRenderData)data).location.z - pos.func_177952_p()));
                    MekanismRenderer.Model3D gasModel = ModelRenderer.getModel(data, 1.0);
                    MekanismRenderer.renderObject(gasModel, matrix, buffer, ((GasRenderData)data).getColorARGB(tile.prevSteamScale), data.calculateGlowLight(light));
                    matrix.func_227865_b_();
                }
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "thermoelectricBoiler";
    }

    public boolean isGlobalRenderer(TileEntityBoilerCasing tile) {
        return tile.clientHasStructure && tile.isRendering && tile.structure != null && ((SynchronizedBoilerData)tile.structure).renderLocation != null && ((SynchronizedBoilerData)tile.structure).upperRenderLocation != null;
    }
}

