/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.model.data.ModelProperties;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;

public class TransmitterModelConfiguration
extends VisibleModelConfiguration {
    @Nonnull
    private IModelData modelData;

    public TransmitterModelConfiguration(IModelConfiguration internal, List<String> visibleGroups, @Nonnull IModelData modelData) {
        super(internal, visibleGroups);
        this.modelData = modelData;
    }

    @Nullable
    private static Direction directionForPiece(@Nonnull String piece) {
        if (piece.endsWith("down")) {
            return Direction.DOWN;
        }
        if (piece.endsWith("up")) {
            return Direction.UP;
        }
        if (piece.endsWith("north")) {
            return Direction.NORTH;
        }
        if (piece.endsWith("south")) {
            return Direction.SOUTH;
        }
        if (piece.endsWith("east")) {
            return Direction.EAST;
        }
        if (piece.endsWith("west")) {
            return Direction.WEST;
        }
        return null;
    }

    private String adjustTextureName(String name) {
        Direction direction = TransmitterModelConfiguration.directionForPiece(name);
        if (direction != null) {
            if (this.getIconStatus(direction) != IconStatus.NO_SHOW) {
                String string = name = name.contains("glass") ? "#side_glass" : "#side";
            }
            if (MekanismConfig.client.opaqueTransmitters.get()) {
                if (name.startsWith("#side")) {
                    return name + "_opaque";
                }
                if (name.startsWith("#center")) {
                    return name.contains("glass") ? "#center_glass_opaque" : "#center_opaque";
                }
            }
            return name;
        }
        if (MekanismConfig.client.opaqueTransmitters.get() && name.startsWith("#side")) {
            return name + "_opaque";
        }
        return name;
    }

    public IconStatus getIconStatus(Direction side) {
        if (this.modelData instanceof TransmitterModelData.Diversion) {
            return IconStatus.NO_SHOW;
        }
        boolean hasDown = this.modelData.getData(ModelProperties.DOWN_CONNECTION) != TileEntitySidedPipe.ConnectionType.NONE;
        boolean hasUp = this.modelData.getData(ModelProperties.UP_CONNECTION) != TileEntitySidedPipe.ConnectionType.NONE;
        boolean hasNorth = this.modelData.getData(ModelProperties.NORTH_CONNECTION) != TileEntitySidedPipe.ConnectionType.NONE;
        boolean hasSouth = this.modelData.getData(ModelProperties.SOUTH_CONNECTION) != TileEntitySidedPipe.ConnectionType.NONE;
        boolean hasWest = this.modelData.getData(ModelProperties.WEST_CONNECTION) != TileEntitySidedPipe.ConnectionType.NONE;
        boolean hasEast = this.modelData.getData(ModelProperties.EAST_CONNECTION) != TileEntitySidedPipe.ConnectionType.NONE;
        boolean hasConnection = false;
        if (side == Direction.DOWN) {
            hasConnection = hasDown;
        } else if (side == Direction.UP) {
            hasConnection = hasUp;
        } else if (side == Direction.NORTH) {
            hasConnection = hasNorth;
        } else if (side == Direction.SOUTH) {
            hasConnection = hasSouth;
        } else if (side == Direction.WEST) {
            hasConnection = hasWest;
        } else if (side == Direction.EAST) {
            hasConnection = hasEast;
        }
        if (!hasConnection) {
            boolean hasUpDown = hasDown || hasUp;
            boolean hasNorthSouth = hasNorth || hasSouth;
            boolean hasEastWest = hasEast || hasWest;
            switch (side) {
                case DOWN: 
                case UP: {
                    if ((!hasNorthSouth || hasEastWest) && (hasNorthSouth || !hasEastWest)) break;
                    if (hasNorth && hasSouth) {
                        return IconStatus.NO_ROTATION;
                    }
                    if (!hasEast || !hasWest) break;
                    return IconStatus.ROTATE_270;
                }
                case NORTH: 
                case SOUTH: {
                    if ((!hasUpDown || hasEastWest) && (hasUpDown || !hasEastWest)) break;
                    if (hasUp && hasDown) {
                        return IconStatus.NO_ROTATION;
                    }
                    if (!hasEast || !hasWest) break;
                    return IconStatus.ROTATE_270;
                }
                case WEST: 
                case EAST: {
                    if ((!hasUpDown || hasNorthSouth) && (hasUpDown || !hasNorthSouth)) break;
                    if (hasUp && hasDown) {
                        return IconStatus.NO_ROTATION;
                    }
                    if (!hasNorth || !hasSouth) break;
                    return IconStatus.ROTATE_270;
                }
            }
        }
        return IconStatus.NO_SHOW;
    }

    @Override
    public boolean isTexturePresent(@Nonnull String name) {
        return this.internal.isTexturePresent(this.adjustTextureName(name));
    }

    @Override
    @Nonnull
    public Material resolveTexture(@Nonnull String name) {
        return this.internal.resolveTexture(this.adjustTextureName(name));
    }

    public static enum IconStatus {
        NO_ROTATION(0.0f),
        ROTATE_270(270.0f),
        NO_SHOW(0.0f);

        private float angle;

        private IconStatus(float angle) {
            this.angle = angle;
        }

        public float getAngle() {
            return this.angle;
        }
    }
}

