/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import mekanism.api.providers.IBlockProvider;
import mekanism.client.gui.GuiAdvancedElectricMachine;
import mekanism.client.gui.GuiElectricMachine;
import mekanism.client.gui.GuiRotaryCondensentrator;
import mekanism.common.block.machine.prefab.BlockFactoryMachine;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.item.block.machine.ItemBlockMachine;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPurificationChamber;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.ResourceLocation;

public class GuiHandlerRegistryHelper {
    public static <T extends ContainerScreen<?>> void register(IGuiHandlerRegistration registry, IBlockProvider mekanismBlock, Class<? extends T> guiContainerClass, int xPos, int yPos, int width, int height) {
        registry.addRecipeClickArea(guiContainerClass, xPos, yPos, width, height, new ResourceLocation[]{mekanismBlock.getRegistryName()});
    }

    public static <T extends ContainerScreen<?>> void register(IGuiHandlerRegistration registry, Class<? extends T> guiContainerClass, ResourceLocation recipeType, int xPos, int yPos, int width, int height) {
        registry.addRecipeClickArea(guiContainerClass, xPos, yPos, width, height, new ResourceLocation[]{recipeType});
    }

    public static void registerCondensentrator(IGuiHandlerRegistration registry) {
        ResourceLocation condensentrating = new ResourceLocation("mekanism", "rotary_condensentrator_condensentrating");
        ResourceLocation decondensentrating = new ResourceLocation("mekanism", "rotary_condensentrator_decondensentrating");
        registry.addRecipeClickArea(GuiRotaryCondensentrator.class, 64, 39, 48, 8, new ResourceLocation[]{condensentrating, decondensentrating});
    }

    public static void registerElectricMachines(IGuiHandlerRegistration registry) {
        registry.addGuiContainerHandler(GuiElectricMachine.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiElectricMachine>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(GuiElectricMachine containerScreen) {
                Object tile = containerScreen.getTileEntity();
                ArrayList<ResourceLocation> categories = new ArrayList<ResourceLocation>();
                if (tile instanceof TileEntityCrusher) {
                    categories.add(MekanismBlocks.CRUSHER.getRegistryName());
                } else if (tile instanceof TileEntityEnrichmentChamber) {
                    categories.add(MekanismBlocks.ENRICHMENT_CHAMBER.getRegistryName());
                } else if (tile instanceof TileEntityEnergizedSmelter) {
                    BlockRegistryObject<BlockFactoryMachine<TileEntityEnergizedSmelter, Machine.FactoryMachine<TileEntityEnergizedSmelter>>, ItemBlockMachine> mekanismBlock = MekanismBlocks.ENERGIZED_SMELTER;
                    categories.add(VanillaRecipeCategoryUid.FURNACE);
                }
                return Collections.singleton(IGuiClickableArea.createBasic((int)79, (int)40, (int)24, (int)7, (ResourceLocation[])categories.toArray(new ResourceLocation[0])));
            }
        });
    }

    public static void registerAdvancedElectricMachines(IGuiHandlerRegistration registry) {
        registry.addGuiContainerHandler(GuiAdvancedElectricMachine.class, (IGuiContainerHandler)new IGuiContainerHandler<GuiAdvancedElectricMachine>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(GuiAdvancedElectricMachine containerScreen) {
                Object tile = containerScreen.getTileEntity();
                ArrayList<ResourceLocation> categories = new ArrayList<ResourceLocation>();
                if (tile instanceof TileEntityOsmiumCompressor) {
                    categories.add(MekanismBlocks.OSMIUM_COMPRESSOR.getRegistryName());
                } else if (tile instanceof TileEntityPurificationChamber) {
                    categories.add(MekanismBlocks.PURIFICATION_CHAMBER.getRegistryName());
                } else if (tile instanceof TileEntityChemicalInjectionChamber) {
                    categories.add(MekanismBlocks.CHEMICAL_INJECTION_CHAMBER.getRegistryName());
                }
                return Collections.singleton(IGuiClickableArea.createBasic((int)79, (int)40, (int)24, (int)7, (ResourceLocation[])categories.toArray(new ResourceLocation[0])));
            }
        });
    }
}

