/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiDigitalMiner
extends GuiMekanismTile<TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private MekanismButton startButton;
    private MekanismButton stopButton;
    private MekanismButton configButton;

    public GuiDigitalMiner(MekanismTileContainer<TileEntityDigitalMiner> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 64;
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 7, 8, 58, 69));
        this.addButton(new GuiRedstoneControl(this, this.tile));
        this.addButton(new GuiSecurityTab<TileEntityMekanism>((IGuiWrapper)this, this.tile));
        this.addButton(new GuiUpgradeTab(this, this.tile));
        this.addButton(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityDigitalMiner)this.tile).getEnergyContainer(), 163, 25, 50));
        this.addButton(new GuiVisualsTab(this, (TileEntityDigitalMiner)this.tile));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 143, 26).validity(() -> ((TileEntityDigitalMiner)this.tile).missingStack).with(() -> ((TileEntityDigitalMiner)this.tile).missingStack.func_190926_b() ? SlotOverlay.CHECK : null).hover(this.getOnHover(() -> ((TileEntityDigitalMiner)this.tile).missingStack.func_190926_b() ? MekanismLang.MINER_WELL.translate(new Object[0]) : MekanismLang.MINER_MISSING_BLOCK.translate(new Object[0]))));
        this.addButton(new GuiEnergyInfo(() -> {
            MinerEnergyContainer energyContainer = ((TileEntityDigitalMiner)this.tile).getEnergyContainer();
            FloatingLong perTick = energyContainer.getEnergyPerTick();
            ArrayList<Object> ret = new ArrayList<Object>(4);
            ret.add(MekanismLang.MINER_ENERGY_CAPACITY.translate(EnergyDisplay.of(energyContainer.getMaxEnergy())));
            ret.add(MekanismLang.NEEDED_PER_TICK.translate(EnergyDisplay.of(perTick)));
            if (perTick.greaterThan(energyContainer.getMaxEnergy())) {
                ret.add(MekanismLang.MINER_INSUFFICIENT_BUFFER.translateColored(EnumColor.RED, new Object[0]));
            }
            ret.add(MekanismLang.MINER_BUFFER_FREE.translate(EnergyDisplay.of(energyContainer.getNeeded())));
            return ret;
        }, (IGuiWrapper)this));
        this.startButton = new TranslationButton(this, this.getGuiLeft() + 69, this.getGuiTop() + 17, 60, 20, MekanismLang.BUTTON_START, () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.START_BUTTON, this.tile)));
        this.addButton(this.startButton);
        this.stopButton = new TranslationButton(this, this.getGuiLeft() + 69, this.getGuiTop() + 37, 60, 20, MekanismLang.BUTTON_STOP, () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.STOP_BUTTON, this.tile)));
        this.addButton(this.stopButton);
        this.configButton = new TranslationButton(this, this.getGuiLeft() + 69, this.getGuiTop() + 57, 60, 20, MekanismLang.BUTTON_CONFIG, () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG, this.tile)));
        this.addButton(this.configButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 131, this.getGuiTop() + 47, 14, this.getButtonLocation("reset"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.RESET_BUTTON, this.tile)), this.getOnHover(MekanismLang.MINER_RESET)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 131, this.getGuiTop() + 63, 14, this.getButtonLocation("silk_touch"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SILK_TOUCH_BUTTON, this.tile)), this.getOnHover(MekanismLang.MINER_SILK)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 147, this.getGuiTop() + 47, 14, this.getButtonLocation("auto_eject"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_EJECT_BUTTON, this.tile)), this.getOnHover(MekanismLang.AUTO_EJECT)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 147, this.getGuiTop() + 63, 14, this.getButtonLocation("auto_pull"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_PULL_BUTTON, this.tile)), this.getOnHover(MekanismLang.AUTO_PULL)));
        this.updateEnabledButtons();
    }

    public void tick() {
        super.tick();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.startButton.active = ((TileEntityDigitalMiner)this.tile).searcher.state == ThreadMinerSearch.State.IDLE || !((TileEntityDigitalMiner)this.tile).running;
        this.stopButton.active = ((TileEntityDigitalMiner)this.tile).searcher.state != ThreadMinerSearch.State.IDLE && ((TileEntityDigitalMiner)this.tile).running;
        this.configButton.active = ((TileEntityDigitalMiner)this.tile).searcher.state == ThreadMinerSearch.State.IDLE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntityDigitalMiner)this.tile).getName(), 69, 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 2, 0x404040);
        MekanismLang runningType = ((TileEntityDigitalMiner)this.tile).getEnergyContainer().getEnergyPerTick().greaterThan(((TileEntityDigitalMiner)this.tile).getEnergyContainer().getMaxEnergy()) ? MekanismLang.MINER_LOW_POWER : (((TileEntityDigitalMiner)this.tile).running ? MekanismLang.MINER_RUNNING : MekanismLang.IDLE);
        this.drawString((ITextComponent)runningType.translate(new Object[0]), 9, 10, 52480);
        this.drawString(((TileEntityDigitalMiner)this.tile).searcher.state.getTextComponent(), 9, 19, 52480);
        this.drawString((ITextComponent)MekanismLang.EJECT.translate(BooleanStateDisplay.OnOff.of(((TileEntityDigitalMiner)this.tile).doEject)), 9, 30, 52480);
        this.drawString((ITextComponent)MekanismLang.MINER_AUTO_PULL.translate(BooleanStateDisplay.OnOff.of(((TileEntityDigitalMiner)this.tile).doPull)), 9, 39, 52480);
        this.drawString((ITextComponent)MekanismLang.MINER_SILK_ENABLED.translate(BooleanStateDisplay.OnOff.of(((TileEntityDigitalMiner)this.tile).getSilkTouch())), 9, 48, 52480);
        this.drawString((ITextComponent)MekanismLang.MINER_TO_MINE.translate(new Object[0]), 9, 59, 52480);
        this.drawString(TextComponentUtil.build(((TileEntityDigitalMiner)this.tile).cachedToMine), 9, 68, 52480);
        super.func_146979_b(mouseX, mouseY);
    }
}

