/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransmitterNetworkRegistry {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static TransmitterNetworkRegistry INSTANCE = new TransmitterNetworkRegistry();
    private static boolean loaderRegistered = false;
    private static Logger logger = LogManager.getLogger((String)"MekanismTransmitters");
    private Set<DynamicNetwork<?, ?, ?>> networks = new ObjectOpenHashSet();
    private Set<DynamicNetwork<?, ?, ?>> networksToChange = new ObjectOpenHashSet();
    private Set<IGridTransmitter<?, ?, ?>> invalidTransmitters = new ObjectOpenHashSet();
    private Map<Coord4D, IGridTransmitter<?, ?, ?>> orphanTransmitters = new Object2ObjectOpenHashMap();
    private Map<Coord4D, IGridTransmitter<?, ?, ?>> newOrphanTransmitters = new Object2ObjectOpenHashMap();
    private Map<UUID, DynamicNetwork<?, ?, ?>> clientNetworks = new Object2ObjectOpenHashMap();

    public void addClientNetwork(UUID networkID, DynamicNetwork<?, ?, ?> network) {
        if (!this.clientNetworks.containsKey(networkID)) {
            this.clientNetworks.put(networkID, network);
        }
    }

    @Nullable
    public DynamicNetwork<?, ?, ?> getClientNetwork(UUID networkID) {
        return this.clientNetworks.get(networkID);
    }

    public void removeClientNetwork(DynamicNetwork<?, ?, ?> network) {
        this.clientNetworks.remove(network.getUUID());
    }

    public void clearClientNetworks() {
        this.clientNetworks.clear();
    }

    public static void initiate() {
        if (!loaderRegistered) {
            loaderRegistered = true;
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static void reset() {
        TransmitterNetworkRegistry.getInstance().networks.clear();
        TransmitterNetworkRegistry.getInstance().networksToChange.clear();
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().orphanTransmitters.clear();
        TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.clear();
    }

    public static void invalidateTransmitter(IGridTransmitter<?, ?, ?> transmitter) {
        TransmitterNetworkRegistry.getInstance().invalidTransmitters.add(transmitter);
    }

    public static void registerOrphanTransmitter(IGridTransmitter<?, ?, ?> transmitter) {
        Coord4D coord = transmitter.coord();
        IGridTransmitter<?, ?, ?> previous = TransmitterNetworkRegistry.getInstance().newOrphanTransmitters.put(coord, transmitter);
        if (previous != null && previous != transmitter) {
            logger.error("Different orphan transmitter was already registered at location! {}", (Object)coord.toString());
        }
    }

    public static void registerChangedNetwork(DynamicNetwork<?, ?, ?> network) {
        TransmitterNetworkRegistry.getInstance().networksToChange.add(network);
    }

    public static TransmitterNetworkRegistry getInstance() {
        return INSTANCE;
    }

    public void registerNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.add(network);
    }

    public void removeNetwork(DynamicNetwork<?, ?, ?> network) {
        this.networks.remove(network);
        this.networksToChange.remove(network);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.tickEnd();
        }
    }

    public void tickEnd() {
        this.removeInvalidTransmitters();
        this.assignOrphans();
        this.commitChanges();
        for (DynamicNetwork<?, ?, ?> net : this.networks) {
            net.tick();
        }
    }

    public void removeInvalidTransmitters() {
        if (MekanismAPI.debug && !this.invalidTransmitters.isEmpty()) {
            logger.info("Dealing with " + this.invalidTransmitters.size() + " invalid Transmitters");
        }
        for (IGridTransmitter<?, ?, ?> invalid : this.invalidTransmitters) {
            Object n;
            if (invalid.isOrphan() && invalid.isValid() || (n = invalid.getTransmitterNetwork()) == null) continue;
            ((DynamicNetwork)n).invalidate();
        }
        this.invalidTransmitters.clear();
    }

    public void assignOrphans() {
        this.orphanTransmitters = new Object2ObjectOpenHashMap(this.newOrphanTransmitters);
        this.newOrphanTransmitters.clear();
        if (MekanismAPI.debug && !this.orphanTransmitters.isEmpty()) {
            logger.info("Dealing with " + this.orphanTransmitters.size() + " orphan Transmitters");
        }
        for (IGridTransmitter orphanTransmitter : new Object2ObjectOpenHashMap(this.orphanTransmitters).values()) {
            DynamicNetwork network = this.getNetworkFromOrphan(orphanTransmitter);
            if (network == null) continue;
            this.networksToChange.add(network);
            network.register();
        }
        this.orphanTransmitters.clear();
    }

    public <A, N extends DynamicNetwork<A, N, BUFFER>, BUFFER> DynamicNetwork<A, N, BUFFER> getNetworkFromOrphan(IGridTransmitter<A, N, BUFFER> startOrphan) {
        if (startOrphan.isValid() && startOrphan.isOrphan()) {
            Object network;
            OrphanPathFinder<A, N, BUFFER> finder = new OrphanPathFinder<A, N, BUFFER>(startOrphan);
            finder.start();
            switch (finder.networksFound.size()) {
                case 0: {
                    if (MekanismAPI.debug) {
                        logger.info("No networks found. Creating new network for " + finder.connectedTransmitters.size() + " transmitters");
                    }
                    network = startOrphan.createEmptyNetwork();
                    break;
                }
                case 1: {
                    if (MekanismAPI.debug) {
                        logger.info("Adding " + finder.connectedTransmitters.size() + " transmitters to single found network");
                    }
                    network = (DynamicNetwork)finder.networksFound.iterator().next();
                    break;
                }
                default: {
                    if (MekanismAPI.debug) {
                        logger.info("Merging " + finder.networksFound.size() + " networks with " + finder.connectedTransmitters.size() + " new transmitters");
                    }
                    network = startOrphan.mergeNetworks(finder.networksFound);
                }
            }
            ((DynamicNetwork)network).addNewTransmitters(finder.connectedTransmitters);
            return network;
        }
        return null;
    }

    public void commitChanges() {
        for (DynamicNetwork<?, ?, ?> network : this.networksToChange) {
            network.commit();
        }
        this.networksToChange.clear();
    }

    public String toString() {
        return "Network Registry:\n" + this.networks;
    }

    public ITextComponent[] toComponents() {
        ITextComponent[] components = new ITextComponent[this.networks.size()];
        int i = 0;
        for (DynamicNetwork<?, ?, ?> network : this.networks) {
            components[i++] = network.getTextComponent();
        }
        return components;
    }

    public class OrphanPathFinder<A, N extends DynamicNetwork<A, N, BUFFER>, BUFFER> {
        public IGridTransmitter<A, N, BUFFER> startPoint;
        public Set<Coord4D> iterated = new ObjectOpenHashSet();
        public Set<IGridTransmitter<A, N, BUFFER>> connectedTransmitters = new ObjectOpenHashSet();
        public Set<N> networksFound = new ObjectOpenHashSet();
        private Deque<Coord4D> queue = new LinkedList<Coord4D>();

        public OrphanPathFinder(IGridTransmitter<A, N, BUFFER> start) {
            this.startPoint = start;
        }

        public void start() {
            if (this.queue.peek() != null) {
                logger.error("OrphanPathFinder queue was not empty?!");
                this.queue.clear();
            }
            this.queue.push(this.startPoint.coord());
            while (this.queue.peek() != null) {
                this.iterate(this.queue.removeFirst());
            }
        }

        public void iterate(Coord4D from) {
            if (this.iterated.contains(from)) {
                return;
            }
            this.iterated.add(from);
            if (TransmitterNetworkRegistry.this.orphanTransmitters.containsKey(from)) {
                IGridTransmitter transmitter = (IGridTransmitter)TransmitterNetworkRegistry.this.orphanTransmitters.get(from);
                if (transmitter.isValid() && transmitter.isOrphan() && (this.connectedTransmitters.isEmpty() || this.connectedTransmitters.stream().anyMatch(existing -> existing.isCompatibleWith(transmitter)))) {
                    this.connectedTransmitters.add(transmitter);
                    transmitter.setOrphan(false);
                    for (Direction direction : DIRECTIONS) {
                        Coord4D directionCoord;
                        if (direction.func_176740_k().func_176722_c() && !transmitter.world().func_195588_v(from.getPos().func_177972_a(direction)) || (directionCoord = transmitter.getAdjacentConnectableTransmitterCoord(direction)) == null || this.iterated.contains(directionCoord)) continue;
                        this.queue.addLast(directionCoord);
                    }
                }
            } else {
                this.addNetworkToIterated(from);
            }
        }

        public void addNetworkToIterated(Coord4D from) {
            N net = this.startPoint.getExternalNetwork(from);
            if (net != null && ((DynamicNetwork)net).compatibleWithBuffer(this.startPoint.getBuffer()) && (this.networksFound.isEmpty() || ((DynamicNetwork)this.networksFound.iterator().next()).isCompatibleWith(net))) {
                this.networksFound.add(net);
            }
        }
    }
}

