/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class GasToGasRecipe
extends MekanismRecipe
implements Predicate<GasStack> {
    private final GasStackIngredient input;
    private final GasStack output;

    public GasToGasRecipe(ResourceLocation id, GasStackIngredient input, GasStack output) {
        super(id);
        this.input = input;
        this.output = output;
    }

    @Override
    public boolean test(GasStack gasStack) {
        return this.input.test(gasStack);
    }

    public GasStackIngredient getInput() {
        return this.input;
    }

    public GasStack getOutputRepresentation() {
        return this.output;
    }

    @Contract(value="_ -> new", pure=true)
    public GasStack getOutput(GasStack input) {
        return this.output.copy();
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        this.output.writeToPacket(buffer);
    }
}

