/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.fluid;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IExtendedFluidTank
extends IFluidTank,
INBTSerializable<CompoundNBT> {
    public void setStack(FluidStack var1);

    default public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isFluidValid(stack)) {
            return stack;
        }
        int needed = this.getNeeded();
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = stack.isFluidEqual(this.getFluid()))) {
            int toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    this.setStack(new FluidStack(stack, toAdd));
                }
            }
            return new FluidStack(stack, stack.getAmount() - toAdd);
        }
        return stack;
    }

    default public FluidStack extract(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1) {
            return FluidStack.EMPTY;
        }
        FluidStack ret = new FluidStack(this.getFluid(), Math.min(this.getFluidAmount(), amount));
        if (!ret.isEmpty() && action.execute()) {
            this.shrinkStack(ret.getAmount(), action);
        }
        return ret;
    }

    public void onContentsChanged();

    default public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        int maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getFluidAmount() == amount || action.simulate()) {
            return amount;
        }
        this.setStack(new FluidStack(this.getFluid(), amount));
        return amount;
    }

    default public int growStack(int amount, Action action) {
        int current = this.getFluidAmount();
        if (amount > 0) {
            amount = Math.min(amount, this.getNeeded());
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public int shrinkStack(int amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return this.getFluid().isEmpty();
    }

    default public void setEmpty() {
        this.setStack(FluidStack.EMPTY);
    }

    default public boolean isFluidEqual(FluidStack other) {
        return this.getFluid().isFluidEqual(other);
    }

    default public int getNeeded() {
        return Math.max(0, this.getCapacity() - this.getFluidAmount());
    }

    default public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.isEmpty()) {
            nbt.func_218657_a("stored", (INBT)this.getFluid().writeToNBT(new CompoundNBT()));
        }
        return nbt;
    }

    @Deprecated
    default public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        return stack.getAmount() - this.insert(stack, Action.fromFluidAction(action), AutomationType.EXTERNAL).getAmount();
    }

    @Deprecated
    default public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        if (!this.isEmpty() && this.getFluid().isFluidEqual(stack)) {
            return this.extract(stack.getAmount(), Action.fromFluidAction(action), AutomationType.EXTERNAL);
        }
        return FluidStack.EMPTY;
    }

    @Deprecated
    default public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        return this.extract(amount, Action.fromFluidAction(action), AutomationType.EXTERNAL);
    }
}

