/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemStackGasToGasRecipeBuilder
extends MekanismRecipeBuilder<ItemStackGasToGasRecipeBuilder> {
    private final ItemStackIngredient itemInput;
    private final GasStackIngredient gasInput;
    private final GasStack output;

    protected ItemStackGasToGasRecipeBuilder(ItemStackIngredient itemInput, GasStackIngredient gasInput, GasStack output) {
        super(new ResourceLocation("mekanism", "dissolution"));
        this.itemInput = itemInput;
        this.gasInput = gasInput;
        this.output = output;
    }

    public static ItemStackGasToGasRecipeBuilder dissolution(ItemStackIngredient itemInput, GasStackIngredient gasInput, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This dissolution chamber recipe requires a non empty gas output.");
        }
        return new ItemStackGasToGasRecipeBuilder(itemInput, gasInput, output);
    }

    @Override
    protected ItemStackGasToGasRecipeResult getResult(ResourceLocation id) {
        return new ItemStackGasToGasRecipeResult(id);
    }

    public class ItemStackGasToGasRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ItemStackGasToGasRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("itemInput", ItemStackGasToGasRecipeBuilder.this.itemInput.serialize());
            json.add("gasInput", ItemStackGasToGasRecipeBuilder.this.gasInput.serialize());
            json.add("output", SerializerHelper.serializeGasStack(ItemStackGasToGasRecipeBuilder.this.output));
        }
    }
}

