/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.providers.IInfuseTypeProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class InfusionStack
extends ChemicalStack<InfuseType> {
    public static final InfusionStack EMPTY = new InfusionStack(MekanismAPI.EMPTY_INFUSE_TYPE, 0L);

    public InfusionStack(@Nonnull IInfuseTypeProvider infuseTypeProvider, long amount) {
        super(infuseTypeProvider.getInfuseType(), amount);
    }

    public InfusionStack(@Nonnull InfusionStack stack, long amount) {
        this((IInfuseTypeProvider)stack.getType(), amount);
    }

    @Override
    @Nonnull
    protected IRegistryDelegate<InfuseType> getDelegate(InfuseType infuseType) {
        if (MekanismAPI.INFUSE_TYPE_REGISTRY.getKey((IForgeRegistryEntry)infuseType) == null) {
            MekanismAPI.logger.fatal("Failed attempt to create a InfusionStack for an unregistered InfuseType {} (type {})", (Object)infuseType.getRegistryName(), (Object)infuseType.getClass().getName());
            throw new IllegalArgumentException("Cannot create a InfusionStack from an unregistered infusion type");
        }
        return infuseType.delegate;
    }

    @Override
    @Nonnull
    protected InfuseType getEmptyChemical() {
        return MekanismAPI.EMPTY_INFUSE_TYPE;
    }

    @Nonnull
    public static InfusionStack readFromNBT(CompoundNBT nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        InfuseType type = InfuseType.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.func_74763_f("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new InfusionStack(type, amount);
    }

    public static InfusionStack readFromPacket(PacketBuffer buf) {
        InfuseType infuseType = (InfuseType)buf.readRegistryId();
        long amount = buf.func_179260_f();
        if (infuseType.isEmptyType()) {
            return EMPTY;
        }
        return new InfusionStack(infuseType, amount);
    }

    @Nonnull
    public InfusionStack copy() {
        return new InfusionStack(this, this.getAmount());
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InfusionStack) {
            return this.isTypeEqual((InfusionStack)o);
        }
        return false;
    }
}

