/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DataHandlerUtils {
    public static void readTanks(List<? extends INBTSerializable<CompoundNBT>> tanks, ListNBT storedTanks) {
        DataHandlerUtils.readContents(tanks, storedTanks, "Tank");
    }

    public static ListNBT writeTanks(List<? extends INBTSerializable<CompoundNBT>> tanks) {
        return DataHandlerUtils.writeContents(tanks, "Tank");
    }

    public static void readContainers(List<? extends INBTSerializable<CompoundNBT>> containers, ListNBT storedContainers) {
        DataHandlerUtils.readContents(containers, storedContainers, "Container");
    }

    public static ListNBT writeContainers(List<? extends INBTSerializable<CompoundNBT>> containers) {
        return DataHandlerUtils.writeContents(containers, "Container");
    }

    public static void readSlots(List<? extends INBTSerializable<CompoundNBT>> slots, ListNBT storedSlots) {
        DataHandlerUtils.readContents(slots, storedSlots, "Slot");
    }

    public static ListNBT writeSlots(List<? extends INBTSerializable<CompoundNBT>> slots) {
        return DataHandlerUtils.writeContents(slots, "Slot");
    }

    public static void readContents(List<? extends INBTSerializable<CompoundNBT>> contents, ListNBT storedContents, String key) {
        int size = contents.size();
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            CompoundNBT tagCompound = storedContents.func_150305_b(tagCount);
            byte id = tagCompound.func_74771_c(key);
            if (id < 0 || id >= size) continue;
            contents.get(id).deserializeNBT((INBT)tagCompound);
        }
    }

    public static ListNBT writeContents(List<? extends INBTSerializable<CompoundNBT>> contents, String key) {
        ListNBT storedContents = new ListNBT();
        for (int tank = 0; tank < contents.size(); ++tank) {
            CompoundNBT tagCompound = (CompoundNBT)contents.get(tank).serializeNBT();
            if (tagCompound.isEmpty()) continue;
            tagCompound.func_74774_a(key, (byte)tank);
            storedContents.add((Object)tagCompound);
        }
        return storedContents;
    }

    public static int getMaxId(ListNBT storedContents, String key) {
        byte maxId = -1;
        for (int tagCount = 0; tagCount < storedContents.size(); ++tagCount) {
            byte id = storedContents.func_150305_b(tagCount).func_74771_c(key);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId + 1;
    }
}

