/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn.compat;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.spawn.BlockSpawnerExt;
import shadows.apotheosis.spawn.TileSpawnerExt;

@WailaPlugin
public class SpawnerWailaPlugin
implements IWailaPlugin,
IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final String STATS = "spw_stats";

    public void register(IRegistrar reg) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        reg.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, BlockSpawnerExt.class);
        reg.registerBlockDataProvider((IServerDataProvider)this, BlockSpawnerExt.class);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d()) {
            int[] stats = accessor.getServerData().func_74759_k(STATS);
            if (stats.length != 10) {
                return;
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.mindelay", new Object[]{stats[0]}));
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.maxdelay", new Object[]{stats[1]}));
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.spawncount", new Object[]{stats[2]}));
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.maxnearby", new Object[]{stats[3]}));
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.playerrange", new Object[]{stats[4]}));
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.spawnrange", new Object[]{stats[5]}));
            if (stats[6] == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.ignoreplayers", new Object[0]));
            }
            if (stats[7] == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.ignoreconditions", new Object[0]));
            }
            if (stats[8] == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.ignorecap", new Object[0]));
            }
            if (stats[9] == 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.redstone", new Object[0]));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("waila.spw.sneak", new Object[0]));
        }
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, TileEntity te) {
        if (te instanceof TileSpawnerExt) {
            TileSpawnerExt spw = (TileSpawnerExt)te;
            AbstractSpawner logic = spw.func_145881_a();
            tag.func_74783_a(STATS, new int[]{logic.field_98283_g, logic.field_98293_h, logic.field_98294_i, logic.field_98292_k, logic.field_98289_l, logic.field_98290_m, spw.ignoresPlayers ? 1 : 0, spw.ignoresConditions ? 1 : 0, spw.ignoresCap ? 1 : 0, spw.redstoneEnabled ? 1 : 0});
        }
    }
}

