/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.client.icon.IconProvider;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.client.key.KeyRegistry;
import org.cyclops.cyclopscore.command.CommandConfig;
import org.cyclops.cyclopscore.command.CommandVersion;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.helper.LoggerHelper;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.init.RegistryManager;
import org.cyclops.cyclopscore.modcompat.IMCHandler;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.cyclopscore.proxy.ClientProxyComponent;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;

public abstract class ModBase<T extends ModBase> {
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_GUI = EnumReferenceKey.create("texture_path_gui", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_MODELS = EnumReferenceKey.create("texture_path_models", String.class);
    public static final EnumReferenceKey<String> REFKEY_TEXTURE_PATH_SKINS = EnumReferenceKey.create("texture_path_skins", String.class);
    public static final EnumReferenceKey<Boolean> REFKEY_RETROGEN = EnumReferenceKey.create("retrogen", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_INVALID_RECIPE = EnumReferenceKey.create("crash_on_invalid_recipe", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_CRASH_ON_MODCOMPAT_CRASH = EnumReferenceKey.create("crash_on_modcompat_crash", Boolean.class);
    public static final EnumReferenceKey<Boolean> REFKEY_INFOBOOK_REWARDS = EnumReferenceKey.create("rewards", Boolean.class);
    private final String modId;
    private final LoggerHelper loggerHelper;
    private final ConfigHandler configHandler;
    private final Map<EnumReferenceKey<?>, Object> genericReference = Maps.newHashMap();
    private final List<WorldStorage> worldStorages = Lists.newLinkedList();
    private final RegistryManager registryManager;
    private final RecipeHandler recipeHandler;
    private final IKeyRegistry keyRegistry;
    private final PacketHandler packetHandler;
    private final ModCompatLoader modCompatLoader;
    private final CapabilityConstructorRegistry capabilityConstructorRegistry;
    private final IMCHandler imcHandler;
    private ICommonProxy proxy;
    private ModContainer container;
    private ItemGroup defaultCreativeTab = null;

    public ModBase(String modId, Consumer<T> instanceSetter) {
        instanceSetter.accept(this);
        this.modId = modId;
        this.loggerHelper = this.constructLoggerHelper();
        this.configHandler = this.constructConfigHandler();
        this.registryManager = this.constructRegistryManager();
        this.recipeHandler = this.constructRecipeHandler();
        this.keyRegistry = new KeyRegistry();
        this.packetHandler = this.constructPacketHandler();
        this.modCompatLoader = this.constructModCompatLoader();
        this.capabilityConstructorRegistry = this.constructCapabilityConstructorRegistry();
        this.imcHandler = this.constructIMCHandler();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOWEST, this::afterRegistriesCreated);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.HIGHEST, this::beforeRegistriedFilled);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.runForDist(() -> () -> {
            this.proxy = this.constructClientProxy();
            return this.proxy;
        }, () -> () -> {
            this.proxy = this.constructCommonProxy();
            return this.proxy;
        });
        this.populateDefaultGenericReferences();
        this.onConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().initialize(Lists.newArrayList());
        this.getConfigHandler().loadModInit();
        this.loadModCompats(this.getModCompatLoader());
    }

    public String getModName() {
        return this.getContainer().getModInfo().getDisplayName();
    }

    public ModContainer getContainer() {
        if (this.container == null) {
            this.container = (ModContainer)ModList.get().getModContainerByObject((Object)this).get();
        }
        return this.container;
    }

    protected LoggerHelper constructLoggerHelper() {
        return new LoggerHelper(this.getModId());
    }

    protected ConfigHandler constructConfigHandler() {
        return new ConfigHandler(this);
    }

    protected RegistryManager constructRegistryManager() {
        return new RegistryManager();
    }

    @Deprecated
    protected RecipeHandler constructRecipeHandler() {
        return null;
    }

    protected PacketHandler constructPacketHandler() {
        return new PacketHandler(this);
    }

    protected ModCompatLoader constructModCompatLoader() {
        return new ModCompatLoader(this);
    }

    protected CapabilityConstructorRegistry constructCapabilityConstructorRegistry() {
        return new CapabilityConstructorRegistry(this);
    }

    protected IMCHandler constructIMCHandler() {
        return new IMCHandler(this);
    }

    protected LiteralArgumentBuilder<CommandSource> constructBaseCommand() {
        LiteralArgumentBuilder root = Commands.func_197057_a((String)this.getModId());
        root.then(CommandConfig.make(this));
        root.then(CommandVersion.make(this));
        return root;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IconProvider getIconProvider() {
        return ((ClientProxyComponent)this.getProxy()).getIconProvider();
    }

    public <T> void putGenericReference(EnumReferenceKey<T> key, T value) {
        this.genericReference.put(key, value);
    }

    private void populateDefaultGenericReferences() {
        this.putGenericReference(REFKEY_TEXTURE_PATH_GUI, "textures/gui/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_MODELS, "textures/models/");
        this.putGenericReference(REFKEY_TEXTURE_PATH_SKINS, "textures/skins/");
        this.putGenericReference(REFKEY_RETROGEN, false);
        this.putGenericReference(REFKEY_CRASH_ON_INVALID_RECIPE, false);
        this.putGenericReference(REFKEY_CRASH_ON_MODCOMPAT_CRASH, false);
        this.putGenericReference(REFKEY_INFOBOOK_REWARDS, true);
    }

    protected void loadModCompats(ModCompatLoader modCompatLoader) {
    }

    public <T> T getReferenceValue(EnumReferenceKey<T> key) {
        if (!this.genericReference.containsKey(key)) {
            throw new IllegalArgumentException("Could not find " + key + " as generic reference item.");
        }
        return (T)this.genericReference.get(key);
    }

    public void log(String message) {
        this.log(Level.INFO, message);
    }

    public void log(Level level, String message) {
        this.loggerHelper.log(level, message);
    }

    protected void setup(FMLCommonSetupEvent event) {
        this.log(Level.TRACE, "setup()");
        this.getConfigHandler().loadSetup();
        ICommonProxy proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerRenderers();
            proxy.registerKeyBindings(this.getKeyRegistry());
            this.getPacketHandler().init();
            proxy.registerPacketHandlers(this.getPacketHandler());
            proxy.registerTickHandlers();
        }
        this.getDefaultItemGroup();
    }

    private void afterRegistriesCreated(RegistryEvent.NewRegistry event) {
        this.getConfigHandler().loadForgeRegistries();
    }

    private void beforeRegistriedFilled(RegistryEvent.Register event) {
        if (event.getRegistry() == ForgeRegistries.BLOCKS) {
            this.getConfigHandler().loadForgeRegistriesFilled();
        }
    }

    @SubscribeEvent
    protected void onServerStarting(FMLServerStartingEvent event) {
        event.getCommandDispatcher().register(this.constructBaseCommand());
    }

    @SubscribeEvent
    protected void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onAboutToStartEvent(event);
        }
    }

    @SubscribeEvent
    protected void onServerStarted(FMLServerStartedEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onStartedEvent(event);
        }
    }

    @SubscribeEvent
    protected void onServerStopping(FMLServerStoppingEvent event) {
        for (WorldStorage worldStorage : this.worldStorages) {
            worldStorage.onStoppingEvent(event);
        }
    }

    public void registerWorldStorage(WorldStorage worldStorage) {
        this.worldStorages.add(worldStorage);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract IClientProxy constructClientProxy();

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    protected abstract ICommonProxy constructCommonProxy();

    protected abstract ItemGroup constructDefaultItemGroup();

    protected void onConfigsRegister(ConfigHandler configHandler) {
    }

    public final ItemGroup getDefaultItemGroup() {
        if (this.defaultCreativeTab == null) {
            this.defaultCreativeTab = this.constructDefaultItemGroup();
        }
        return this.defaultCreativeTab;
    }

    public ICommonProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.getModId();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public static ModBase get(String modId) {
        ModContainer modContainer = ModList.get().getModContainerById(modId).orElse(null);
        Object mod = modContainer.getMod();
        if (mod instanceof ModBase) {
            return (ModBase)mod;
        }
        return null;
    }

    public String getModId() {
        return this.modId;
    }

    public LoggerHelper getLoggerHelper() {
        return this.loggerHelper;
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public Map<EnumReferenceKey<?>, Object> getGenericReference() {
        return this.genericReference;
    }

    public List<WorldStorage> getWorldStorages() {
        return this.worldStorages;
    }

    public RegistryManager getRegistryManager() {
        return this.registryManager;
    }

    public RecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    public IKeyRegistry getKeyRegistry() {
        return this.keyRegistry;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public ModCompatLoader getModCompatLoader() {
        return this.modCompatLoader;
    }

    public CapabilityConstructorRegistry getCapabilityConstructorRegistry() {
        return this.capabilityConstructorRegistry;
    }

    public IMCHandler getImcHandler() {
        return this.imcHandler;
    }

    public ItemGroup getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public void setProxy(ICommonProxy proxy) {
        this.proxy = proxy;
    }

    public void setContainer(ModContainer container) {
        this.container = container;
    }

    public void setDefaultCreativeTab(ItemGroup defaultCreativeTab) {
        this.defaultCreativeTab = defaultCreativeTab;
    }

    public static class EnumReferenceKey<T> {
        private final String key;
        private final Class<T> type;

        private EnumReferenceKey(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        public static <T> EnumReferenceKey<T> create(String key, Class<T> type) {
            return new EnumReferenceKey<T>(key, type);
        }

        public String getKey() {
            return this.key;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnumReferenceKey)) {
                return false;
            }
            EnumReferenceKey other = (EnumReferenceKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Class<T> this$type = this.getType();
            Class<T> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnumReferenceKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 0 : $key.hashCode());
            Class<T> $type = this.getType();
            result = result * 59 + ($type == null ? 0 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ModBase.EnumReferenceKey(key=" + this.getKey() + ", type=" + this.getType() + ")";
        }
    }
}

