/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;

public class InfoBookRegistry
implements IInfoBookRegistry {
    private final Map<IInfoBook, String> bookPaths = Maps.newIdentityHashMap();
    private final Map<IInfoBook, InfoSection> bookRoots = Maps.newIdentityHashMap();

    public InfoBookRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void registerInfoBook(IInfoBook infoBook, String path) {
        this.bookPaths.put(infoBook, path);
    }

    @Override
    public void registerSection(IInfoBook infoBook, String parentSection, String sectionPath) {
        InfoSection section = infoBook.getSection(parentSection);
        if (section == null) {
            throw new IllegalArgumentException(String.format("Could not find section '%s' in infobook '%s'.", parentSection, infoBook));
        }
        section.registerSection(InfoBookParser.initializeInfoBook(infoBook, sectionPath, section));
    }

    @Override
    public InfoSection getRoot(IInfoBook infoBook) {
        return this.bookRoots.get(infoBook);
    }

    @SubscribeEvent
    public void onRecipesLoaded(RecipesUpdatedEvent event) {
        for (Map.Entry<IInfoBook, String> entry : this.bookPaths.entrySet()) {
            this.bookRoots.put(entry.getKey(), InfoBookParser.initializeInfoBook(entry.getKey(), entry.getValue(), null));
            entry.getKey().setCurrentSection(null);
        }
    }
}

