/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.core.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.fml.RegistryObject;

public class BoatRegistry {
    private static final Map<String, BoatData> BOATS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), entries -> entries.put("minecraft:oak", new BoatData.DefaultBoatData()));

    public static void registerBoat(String boatName, RegistryObject<Item> boat, RegistryObject<Block> plank) {
        BOATS.put(boatName, new BoatData(boat, plank, boatName));
    }

    @Nullable
    public static BoatData getDataForBoat(String boatName) {
        return BOATS.get(boatName);
    }

    public static String getNameForData(BoatData data) {
        for (Map.Entry<String, BoatData> entries : BOATS.entrySet()) {
            if (!entries.getValue().equals(data)) continue;
            return entries.getKey();
        }
        return BoatRegistry.getBaseBoatName();
    }

    public static String getBaseBoatName() {
        return BOATS.size() > 1 ? (String)BOATS.keySet().toArray()[1] : "minecraft:oak";
    }

    public static class BoatData {
        private final RegistryObject<Item> boat;
        private final RegistryObject<Block> plank;
        private final ResourceLocation texture;

        public BoatData(RegistryObject<Item> boat, RegistryObject<Block> plank, String texture) {
            this.boat = boat;
            this.plank = plank;
            this.texture = this.processTexture(texture);
        }

        public Item getBoatItem() {
            return (Item)this.boat.get();
        }

        public Item getPlankItem() {
            return ((Block)this.plank.get()).func_199767_j();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        private ResourceLocation processTexture(String texture) {
            String parentString = texture;
            String modId = this.findModId(parentString);
            String wood = this.findWood(parentString);
            return new ResourceLocation(modId, "textures/entity/boat/" + wood + ".png");
        }

        private String findModId(String parentString) {
            StringBuilder builder = new StringBuilder();
            for (char parentChars : parentString.toCharArray()) {
                if (parentChars == ':') break;
                builder.append(parentChars);
            }
            return builder.toString();
        }

        private String findWood(String parentString) {
            StringBuilder builder = new StringBuilder();
            boolean start = false;
            for (char parentChars : parentString.toCharArray()) {
                if (start) {
                    builder.append(parentChars);
                }
                if (parentChars != ':') continue;
                start = true;
            }
            return builder.toString();
        }

        public static class DefaultBoatData
        extends BoatData {
            public DefaultBoatData() {
                super(null, null, "minecraft:oak");
            }

            @Override
            public Item getBoatItem() {
                return Items.field_151124_az;
            }

            @Override
            public Item getPlankItem() {
                return Items.field_221586_n.func_199767_j();
            }
        }
    }
}

