/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.tileentity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.teamabnormals.abnormals_core.core.examples.ExampleTileEntityRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AbnormalsSignTileEntity
extends TileEntity {
    public final ITextComponent[] signText = new ITextComponent[]{new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent(""), new StringTextComponent("")};
    private boolean isEditable = true;
    private PlayerEntity player;
    private final String[] renderText = new String[4];
    private DyeColor textColor = DyeColor.BLACK;

    public AbnormalsSignTileEntity() {
        super((TileEntityType)ExampleTileEntityRegistry.SIGN.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        for (int i = 0; i < 4; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.signText[i]);
            compound.func_74778_a("Text" + (i + 1), s);
        }
        compound.func_74778_a("Color", this.textColor.func_176762_d());
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        this.isEditable = false;
        super.func_145839_a(compound);
        this.textColor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        for (int i = 0; i < 4; ++i) {
            String s = compound.func_74779_i("Text" + (i + 1));
            ITextComponent itextcomponent = ITextComponent.Serializer.func_150699_a((String)(s.isEmpty() ? "\"\"" : s));
            if (this.field_145850_b instanceof ServerWorld) {
                try {
                    this.signText[i] = TextComponentUtils.func_197680_a((CommandSource)this.getCommandSource(null), (ITextComponent)itextcomponent, (Entity)null, (int)0);
                }
                catch (CommandSyntaxException var6) {
                    this.signText[i] = itextcomponent;
                }
            } else {
                this.signText[i] = itextcomponent;
            }
            this.renderText[i] = null;
        }
    }

    public ITextComponent getText(int line) {
        return this.signText[line];
    }

    public void setText(int line, ITextComponent p_212365_2_) {
        this.signText[line] = p_212365_2_;
        this.renderText[line] = null;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public String getRenderText(int line, Function<ITextComponent, String> p_212364_2_) {
        if (this.renderText[line] == null && this.signText[line] != null) {
            this.renderText[line] = p_212364_2_.apply(this.signText[line]);
        }
        return this.renderText[line];
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 100, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setEditable(boolean isEditableIn) {
        this.isEditable = isEditableIn;
        if (!isEditableIn) {
            this.player = null;
        }
    }

    public void setPlayer(PlayerEntity playerIn) {
        this.player = playerIn;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public boolean executeCommand(PlayerEntity playerIn) {
        for (ITextComponent itextcomponent : this.signText) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            playerIn.func_184102_h().func_195571_aL().func_197059_a(this.getCommandSource((ServerPlayerEntity)playerIn), clickevent.func_150668_b());
        }
        return true;
    }

    public CommandSource getCommandSource(@Nullable ServerPlayerEntity playerIn) {
        String s = playerIn == null ? "Sign" : playerIn.func_200200_C_().getString();
        StringTextComponent itextcomponent = playerIn == null ? new StringTextComponent("Sign") : playerIn.func_145748_c_();
        return new CommandSource(ICommandSource.field_213139_a_, new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), Vec2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), (Entity)playerIn);
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.getTextColor()) {
            this.textColor = newColor;
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        return false;
    }
}

