/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.common.network;

import com.teamabnormals.abnormals_core.common.tileentity.AbnormalsSignTileEntity;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageC2SEditSign {
    private BlockPos signPos;
    private String topLine;
    private String secondLine;
    private String thirdLine;
    private String bottomLine;

    public MessageC2SEditSign(BlockPos signPos, String topLine, String secondLine, String thirdLine, String bottomLine) {
        this.signPos = signPos;
        this.topLine = topLine;
        this.secondLine = secondLine;
        this.thirdLine = thirdLine;
        this.bottomLine = bottomLine;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_179255_a(this.signPos);
        buf.func_180714_a(this.topLine);
        buf.func_180714_a(this.secondLine);
        buf.func_180714_a(this.thirdLine);
        buf.func_180714_a(this.bottomLine);
    }

    public static MessageC2SEditSign deserialize(PacketBuffer buf) {
        return new MessageC2SEditSign(buf.func_179259_c(), buf.func_150789_c(Short.MAX_VALUE), buf.func_150789_c(Short.MAX_VALUE), buf.func_150789_c(Short.MAX_VALUE), buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(MessageC2SEditSign message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayerEntity player = context.getSender();
                player.func_143004_u();
                MinecraftServer server = player.func_184102_h();
                ServerWorld world = server.func_71218_a(player.field_71093_bK);
                BlockPos blockpos = message.signPos;
                if (world.func_175667_e(blockpos)) {
                    BlockState blockstate = world.func_180495_p(blockpos);
                    TileEntity tileentity = world.func_175625_s(blockpos);
                    if (!(tileentity instanceof AbnormalsSignTileEntity)) {
                        return;
                    }
                    AbnormalsSignTileEntity signtileentity = (AbnormalsSignTileEntity)tileentity;
                    if (!signtileentity.getIsEditable() || signtileentity.getPlayer() != player) {
                        server.func_71236_h("Player " + player.func_200200_C_().getString() + " just tried to change non-editable sign");
                        return;
                    }
                    signtileentity.setText(0, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.topLine)));
                    signtileentity.setText(1, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.secondLine)));
                    signtileentity.setText(2, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.thirdLine)));
                    signtileentity.setText(3, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.bottomLine)));
                    signtileentity.func_70296_d();
                    world.func_184138_a(blockpos, blockstate, blockstate, 3);
                    NetworkUtil.updateSignText(signtileentity.func_174877_v(), signtileentity.signText[0], signtileentity.signText[1], signtileentity.signText[2], signtileentity.signText[3], signtileentity.getTextColor());
                }
            });
            context.setPacketHandled(true);
        }
    }
}

