/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.client.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teamabnormals.abnormals_core.common.entity.AbnormalsBoatEntity;
import java.util.Arrays;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbnormalsBoatRenderer
extends EntityRenderer<AbnormalsBoatEntity> {
    protected final AbnormalsBoatModel model = new AbnormalsBoatModel();

    public AbnormalsBoatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.8f;
    }

    public void render(AbnormalsBoatEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float f2;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, 0.375, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float f = (float)entity.func_70268_h() - partialTicks;
        float f1 = entity.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.func_70267_i()));
        }
        if (!MathHelper.func_180185_a((float)(f2 = entity.func_203056_b(partialTicks)), (float)0.0f)) {
            matrixStackIn.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.func_203056_b(partialTicks), true));
        }
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        this.model.setRotationAngles(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.model.func_228282_a_(this.getEntityTexture(entity)));
        this.model.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(RenderType.func_228651_i_());
        this.model.func_228245_c_().func_228308_a_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getEntityTexture(AbnormalsBoatEntity entity) {
        return entity.getBoat().getTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class AbnormalsBoatModel
    extends SegmentedModel<AbnormalsBoatEntity> {
        private final ModelRenderer[] paddles = new ModelRenderer[2];
        private final ModelRenderer noWater;
        private final ImmutableList<ModelRenderer> field_228243_f_;

        public AbnormalsBoatModel() {
            ModelRenderer[] amodelrenderer = new ModelRenderer[]{new ModelRenderer((Model)this, 0, 0).func_78787_b(128, 64), new ModelRenderer((Model)this, 0, 19).func_78787_b(128, 64), new ModelRenderer((Model)this, 0, 27).func_78787_b(128, 64), new ModelRenderer((Model)this, 0, 35).func_78787_b(128, 64), new ModelRenderer((Model)this, 0, 43).func_78787_b(128, 64)};
            amodelrenderer[0].func_228301_a_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f, 0.0f);
            amodelrenderer[0].func_78793_a(0.0f, 3.0f, 1.0f);
            amodelrenderer[1].func_228301_a_(-13.0f, -7.0f, -1.0f, 18.0f, 6.0f, 2.0f, 0.0f);
            amodelrenderer[1].func_78793_a(-15.0f, 4.0f, 4.0f);
            amodelrenderer[2].func_228301_a_(-8.0f, -7.0f, -1.0f, 16.0f, 6.0f, 2.0f, 0.0f);
            amodelrenderer[2].func_78793_a(15.0f, 4.0f, 0.0f);
            amodelrenderer[3].func_228301_a_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f, 0.0f);
            amodelrenderer[3].func_78793_a(0.0f, 4.0f, -9.0f);
            amodelrenderer[4].func_228301_a_(-14.0f, -7.0f, -1.0f, 28.0f, 6.0f, 2.0f, 0.0f);
            amodelrenderer[4].func_78793_a(0.0f, 4.0f, 9.0f);
            amodelrenderer[0].field_78795_f = 1.5707964f;
            amodelrenderer[1].field_78796_g = 4.712389f;
            amodelrenderer[2].field_78796_g = 1.5707964f;
            amodelrenderer[3].field_78796_g = (float)Math.PI;
            this.paddles[0] = this.makePaddle(true);
            this.paddles[0].func_78793_a(3.0f, -5.0f, 9.0f);
            this.paddles[1] = this.makePaddle(false);
            this.paddles[1].func_78793_a(3.0f, -5.0f, -9.0f);
            this.paddles[1].field_78796_g = (float)Math.PI;
            this.paddles[0].field_78808_h = 0.19634955f;
            this.paddles[1].field_78808_h = 0.19634955f;
            this.noWater = new ModelRenderer((Model)this, 0, 0).func_78787_b(128, 64);
            this.noWater.func_228301_a_(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f, 0.0f);
            this.noWater.func_78793_a(0.0f, -3.0f, 1.0f);
            this.noWater.field_78795_f = 1.5707964f;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(Arrays.asList(amodelrenderer));
            builder.addAll(Arrays.asList(this.paddles));
            this.field_228243_f_ = builder.build();
        }

        public void setRotationAngles(AbnormalsBoatEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.func_228244_a_(entityIn, 0, limbSwing);
            this.func_228244_a_(entityIn, 1, limbSwing);
        }

        public ImmutableList<ModelRenderer> getParts() {
            return this.field_228243_f_;
        }

        public ModelRenderer func_228245_c_() {
            return this.noWater;
        }

        protected ModelRenderer makePaddle(boolean p_187056_1_) {
            ModelRenderer modelrenderer = new ModelRenderer((Model)this, 62, p_187056_1_ ? 0 : 20).func_78787_b(128, 64);
            modelrenderer.func_228300_a_(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f);
            modelrenderer.func_228300_a_(p_187056_1_ ? -1.001f : 0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f);
            return modelrenderer;
        }

        protected void func_228244_a_(AbnormalsBoatEntity p_228244_1_, int p_228244_2_, float p_228244_3_) {
            float f = p_228244_1_.func_184448_a(p_228244_2_, p_228244_3_);
            ModelRenderer modelrenderer = this.paddles[p_228244_2_];
            modelrenderer.field_78795_f = (float)MathHelper.func_151238_b((double)-1.0471975803375244, (double)-0.2617993950843811, (double)((MathHelper.func_76126_a((float)(-f)) + 1.0f) / 2.0f));
            modelrenderer.field_78796_g = (float)MathHelper.func_151238_b((double)-0.7853981852531433, (double)0.7853981852531433, (double)((MathHelper.func_76126_a((float)(-f + 1.0f)) + 1.0f) / 2.0f));
            if (p_228244_2_ == 1) {
                modelrenderer.field_78796_g = (float)Math.PI - modelrenderer.field_78796_g;
            }
        }
    }
}

