/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;

public abstract class StateButtonAddon
extends BasicButtonAddon {
    private StateButtonInfo[] buttonInfos = new StateButtonInfo[0];

    public StateButtonAddon(ButtonComponent buttonComponent, StateButtonInfo ... buttonInfos) {
        super(buttonComponent);
        if (buttonInfos != null) {
            this.buttonInfos = buttonInfos;
        }
    }

    @Override
    public void drawBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AssetUtil.drawAsset(screen, provider.getAsset(buttonInfo.getAsset()), this.getPosX() + guiX, this.getPosY() + guiY);
        }
    }

    @Override
    public void drawForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null && this.isInside(screen, mouseX, mouseY)) {
            AssetUtil.drawSelectingOverlay(this.getPosX() + 1, this.getPosY() + 1, this.getPosX() + this.getXSize() - 1, this.getPosY() + this.getYSize() - 1);
        }
    }

    @Override
    public List<String> getTooltipLines() {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            return Arrays.asList(buttonInfo.getTooltip());
        }
        return null;
    }

    public StateButtonInfo getStateInfo() {
        for (StateButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.getState() != this.getState()) continue;
            return buttonInfo;
        }
        return null;
    }

    public abstract int getState();
}

