/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.TextFormatting;

public class ProgressBarScreenAddon<T extends IComponentHarness>
extends BasicScreenAddon {
    private ProgressBarComponent<T> progressBar;
    private IAssetProvider provider;

    public ProgressBarScreenAddon(int posX, int posY, ProgressBarComponent<T> progressBarComponent) {
        super(posX, posY);
        this.progressBar = progressBarComponent;
    }

    @Override
    public int getXSize() {
        return this.provider != null ? this.progressBar.getBarDirection().getXSize(this.provider) : 0;
    }

    @Override
    public int getYSize() {
        return this.provider != null ? this.progressBar.getBarDirection().getYSize(this.provider) : 0;
    }

    @Override
    public void drawBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.provider = provider;
        this.progressBar.getBarDirection().render(screen, guiX, guiY, provider, this);
    }

    @Override
    public void drawForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
    }

    public ProgressBarComponent<T> getProgressBar() {
        return this.progressBar;
    }

    @Override
    public List<String> getTooltipLines() {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add(TextFormatting.GOLD + "Progress: " + TextFormatting.WHITE + new DecimalFormat().format(this.progressBar.getProgress()) + TextFormatting.GOLD + "/" + TextFormatting.WHITE + new DecimalFormat().format(this.progressBar.getMaxProgress()));
        int progress = (this.progressBar.getMaxProgress() - this.progressBar.getProgress()) / this.progressBar.getProgressIncrease();
        if (!this.progressBar.getIncreaseType()) {
            progress = this.progressBar.getMaxProgress() - progress;
        }
        tooltip.add(TextFormatting.GOLD + "ETA: " + TextFormatting.WHITE + new DecimalFormat().format(Math.ceil((double)(progress * this.progressBar.getTickingTime()) / 20.0)) + TextFormatting.DARK_AQUA + "s");
        return tooltip;
    }
}

