/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ItemstackFilterScreenAddon
extends BasicScreenAddon
implements IClickable {
    private final ItemStackFilter filter;

    public ItemstackFilterScreenAddon(ItemStackFilter filter) {
        super(filter.getFilterSlots()[0].getX(), filter.getFilterSlots()[0].getY());
        this.filter = filter;
    }

    @Override
    public int getXSize() {
        return this.filter.getFilterSlots()[this.filter.getFilterSlots().length - 1].getX() + 17;
    }

    @Override
    public int getYSize() {
        return this.filter.getFilterSlots()[this.filter.getFilterSlots().length - 1].getY() + 17;
    }

    @Override
    public void drawBackgroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
            if (filterSlot == null) continue;
            Color color = new Color(filterSlot.getColor());
            AssetUtil.drawAsset(screen, Objects.requireNonNull(provider.getAsset(AssetTypes.SLOT)), guiX + filterSlot.getX(), guiY + filterSlot.getY());
            AbstractGui.fill((int)(guiX + filterSlot.getX() + 1), (int)(guiY + filterSlot.getY() + 1), (int)(guiX + filterSlot.getX() + 17), (int)(guiY + filterSlot.getY() + 17), (int)new Color(color.getRed(), color.getGreen(), color.getBlue(), 128).getRGB());
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (filterSlot.getFilter().func_190926_b()) continue;
            RenderHelper.func_227780_a_();
            Minecraft.func_71410_x().func_175599_af().func_175042_a(filterSlot.getFilter(), filterSlot.getX() + guiX + 1, filterSlot.getY() + guiY + 1);
        }
    }

    @Override
    public void drawForegroundLayer(Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY) {
        for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
            if (filterSlot == null || mouseX <= guiX + filterSlot.getX() + 1 || mouseX >= guiX + filterSlot.getX() + 16 || mouseY <= guiY + filterSlot.getY() + 1 || mouseY >= guiY + filterSlot.getY() + 16) continue;
            RenderSystem.translated((double)0.0, (double)0.0, (double)200.0);
            AbstractGui.fill((int)(filterSlot.getX() + 1), (int)(filterSlot.getY() + 1), (int)(filterSlot.getX() + 17), (int)(filterSlot.getY() + 17), (int)-2130706433);
            RenderSystem.translated((double)0.0, (double)0.0, (double)-200.0);
            if (filterSlot.getFilter().func_190926_b() || !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) continue;
            screen.renderTooltip(screen.getTooltipFromItem(filterSlot.getFilter()), mouseX - guiX, mouseY - guiY);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void handleClick(Screen screen, int guiX, int guiY, double mouseX, double mouseY, int button) {
        if (screen instanceof ContainerScreen && ((ContainerScreen)screen).func_212873_a_() instanceof ILocatable) {
            ILocatable locatable = (ILocatable)((ContainerScreen)screen).func_212873_a_();
            for (FilterSlot<ItemStack> filterSlot : this.filter.getFilterSlots()) {
                if (filterSlot == null || !(mouseX > (double)(guiX + filterSlot.getX() + 1)) || !(mouseX < (double)(guiX + filterSlot.getX() + 16)) || !(mouseY > (double)(guiY + filterSlot.getY() + 1)) || !(mouseY < (double)(guiY + filterSlot.getY() + 16))) continue;
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_74778_a("Name", this.filter.getName());
                compoundNBT.func_74768_a("Slot", filterSlot.getFilterID());
                compoundNBT.func_218657_a("Filter", (INBT)Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().serializeNBT());
                Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -2, compoundNBT));
            }
        }
    }
}

