/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.networking.BlackFirePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class BlackFlameEyesPotion
extends EyesPotion {
    protected BlackFlameEyesPotion() {
        super(ModEffects.getColorNumber(116, 232, 0));
    }

    public static void blackFlameEyesPotionFinish(LivingEntity player) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            mahou.setPlayerPrevYaw(0.0f);
            mahou.setPlayerPrevPitch(0.0f);
            mahou.setPlayerPrevEyePos(null);
        }
    }

    public static void blackFlameEyesPlayerTick(PlayerEntity player) {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        if (mahou != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BLACK_FLAME_EYES)) {
            Entity e = ProjectionSpellEffect.playerLook((LivingEntity)player, MTConfig.BLACK_FLAME_RANGE_FROM_USER, player.field_70170_p, null);
            if (e instanceof LivingEntity) {
                EffectUtil.buff((LivingEntity)e, ModEffects.BLACK_BURNING, false, 180);
                BlackFlameEyesPotion.notifyIfBurning((LivingEntity)e);
            } else {
                float prevYaw = mahou.getPlayerPrevYaw();
                float prevPitch = mahou.getPlayerPrevPitch();
                Vec3d prevEye = mahou.getPlayerPrevEyePos();
                if (prevYaw == 0.0f) {
                    prevYaw = player.field_70177_z;
                }
                if (prevPitch == 0.0f) {
                    prevPitch = player.field_70125_A;
                }
                if (prevEye == null) {
                    prevEye = player.func_174824_e(1.0f);
                }
                float yawDistance = player.field_70177_z - prevYaw;
                float pitchDistance = player.field_70125_A - prevPitch;
                Vec3d eyeDistance = player.func_174824_e(1.0f).func_178788_d(prevEye);
                for (int i = 1; i < 21; ++i) {
                    BlockRayTraceResult result = BlackFlameEyesPotion.rayTrace(MTConfig.BLACK_FLAME_RANGE_FROM_USER, player, eyeDistance.func_186678_a((double)((float)i / 20.0f)).func_178787_e(prevEye), yawDistance * (float)i / 20.0f + prevYaw, pitchDistance * (float)i / 20.0f + prevPitch);
                    if (result == null) continue;
                    BlockPos pos = result.func_216350_a();
                    Direction hit = result.func_216354_b();
                    EffectUtil.tryChangeBlockState(false, pos.func_177972_a(hit), ModBlocks.blackFireBlock.func_176223_P(), player.field_70170_p, player);
                }
                mahou.setPlayerPrevYaw(player.field_70177_z);
                mahou.setPlayerPrevPitch(player.field_70125_A);
                mahou.setPlayerPrevEyePos(player.func_174824_e(1.0f));
            }
        }
    }

    public static void blackFlameEyesLivingUpdate(LivingEntity entity) {
        if (entity != null && entity.func_70089_S() && !entity.field_70170_p.field_72995_K) {
            if (entity.field_70170_p.func_72820_D() % 20L == 0L && EffectUtil.hasBuff(entity, ModEffects.BLACK_BURNING)) {
                entity.func_70097_a(DamageSource.field_82727_n, 1.0f);
            }
            if (BlackFlameEyesPotion.isFlammableWithin(entity.func_174813_aQ().func_186664_h(0.001), entity.field_70170_p)) {
                EffectUtil.buff(entity, ModEffects.BLACK_BURNING, false, 180);
                BlackFlameEyesPotion.notifyIfBurning(entity);
            }
        }
    }

    public static boolean isFlammableWithin(AxisAlignedBB bb, World world) {
        int j1;
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        if (world.func_217344_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)bb.field_72334_f))) {
            try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
                for (int k1 = i; k1 < j; ++k1) {
                    for (int l1 = k; l1 < l; ++l1) {
                        for (int i2 = i1; i2 < j1; ++i2) {
                            boolean flag;
                            BlockState state = world.func_180495_p((BlockPos)blockpos$pooledmutable.func_181079_c(k1, l1, i2));
                            if (state.func_177230_c() != ModBlocks.blackFireBlock) continue;
                            boolean bl = flag = true;
                            return bl;
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    public static final Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static BlockRayTraceResult rayTrace(double blockReachDistance, PlayerEntity player, Vec3d v, float yaw, float pitch) {
        RayTraceResult zz = player.func_213324_a(blockReachDistance, 1.0f, false);
        Object pos = null;
        if (zz instanceof BlockRayTraceResult) {
            return (BlockRayTraceResult)zz;
        }
        return null;
    }

    public static void notifyIfBurning(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.BLACK_BURNING)) {
            BlackFlameEyesPotion.notifyTracking(lst, true, e.field_70170_p);
        }
    }

    public static void notifyNotBurning(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        BlackFlameEyesPotion.notifyTracking(lst, false, e.field_70170_p);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, World world) {
        if (world instanceof ServerWorld) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new BlackFirePacket(e.func_145782_y(), r));
            }
        }
    }
}

