/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic.MysticStaff;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaff
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_AOE_MODE_ON";
    private static final int beamGrowthStart = 35;
    private static final float beamGrowthRate = 1.026f;
    private ArrayList<MysticStaffMahoujinEntity> mahoujins;
    private boolean growthStopped = false;
    private Vec3d target = null;
    private List<Vec3d> aoeTargets = null;
    private MysticStaffMahoujinEntity highest = null;
    private MysticStaffMahoujinEntity lowest = null;
    private float playerLook = 0.0f;
    private float playerPitch = 0.0f;
    private int aoeSpawnIndex = 0;
    private static final float highestRadius = 35.0f;

    public MysticStaff() {
        super("mystic_staff", ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1, 20);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof MysticStaff) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                return !(entityIn.func_184607_cu().func_77973_b() instanceof MysticStaff) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.growthStopped = false;
        this.mahoujins = null;
        this.target = null;
        this.aoeTargets = null;
        this.aoeSpawnIndex = 0;
        if (player.func_226273_bm_()) {
            if (!world.field_72995_K) {
                this.setAOEMode(stack, !this.getAOEMode(stack));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void setAOEMode(ItemStack staff, boolean aoe) {
        CompoundNBT nbt = staff.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74757_a(this.MODE_TAG, aoe);
        staff.func_77982_d(nbt);
    }

    public boolean getAOEMode(ItemStack staff) {
        CompoundNBT nbt = staff.func_77978_p();
        if (nbt != null && nbt.func_74764_b(this.MODE_TAG)) {
            return nbt.func_74767_n(this.MODE_TAG);
        }
        return false;
    }

    public static float getBeamSize(MysticStaffMahoujinEntity entity, float partialTicks) {
        float last = entity.getBeamSize() / 1.026f;
        return last + partialTicks * (entity.getBeamSize() - last);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!this.getAOEMode(stack)) {
            player.func_213293_j(0.0, player.func_213322_ci().field_72448_b * 0.3, 0.0);
            int charge = this.getRemainingUseDuration(stack, count);
            if (this.mahoujins == null) {
                this.mahoujins = new ArrayList();
            }
            if (!player.field_70170_p.field_72995_K) {
                float thunderChance;
                if (this.target == null) {
                    this.target = this.getTargetBlock((PlayerEntity)player);
                }
                if (charge == 1) {
                    this.createFloorCircle((PlayerEntity)player, new Vec3d(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_()), 3.0f, 0.5f);
                    this.createFloorCircle((PlayerEntity)player, this.target.func_178787_e(new Vec3d(0.0, 1.0, 0.0)), 12.0f, 0.5f);
                }
                if (charge == 5) {
                    this.lowest = this.createCircleAtAngle((PlayerEntity)player, 10.0f, 1.5f, 10.0f, 30.0f, 15.0f, this.target, true, 0.1f, false);
                }
                if (charge == 8) {
                    this.createCircleAtAngle((PlayerEntity)player, 15.0f, 0.5f, 10.0f, 30.0f, 22.0f, this.target, false, 0.0f, false);
                }
                if (charge == 13) {
                    this.createCircleAtAngle((PlayerEntity)player, 20.0f, 2.0f, 10.0f, 30.0f, 30.0f, this.target, false, 0.0f, false);
                }
                if (charge == 15) {
                    this.highest = this.createCircleAtAngle((PlayerEntity)player, 35.0f, 1.0f, 10.0f, 30.0f, 37.0f, this.target, true, 0.1f, false);
                }
                if (charge > 15 && this.highest != null && (double)(thunderChance = player.func_70681_au().nextFloat()) < 0.1) {
                    int angle = player.func_70681_au().nextInt(360);
                    float radius = (float)player.func_70681_au().nextInt(20) + 35.0f;
                    double addX = (double)(-radius) * Math.cos(MysticStaffMahoujinEntity.toRad(angle));
                    double addZ = (double)radius * Math.sin(MysticStaffMahoujinEntity.toRad(angle));
                    double addY = player.func_70681_au().nextInt(10) - 5;
                    ((ServerWorld)player.field_70170_p).func_217468_a(new LightningBoltEntity(player.field_70170_p, this.highest.func_226277_ct_() + addX, this.highest.func_226278_cu_() + addY, this.highest.func_226281_cx_() + addZ, true));
                }
                if (charge > 35 && this.lowest != null && this.highest != null) {
                    if (this.highest.getBeamSize() < 0.6f) {
                        this.lowest.setBeamSize(this.lowest.getBeamSize() * 1.026f);
                        this.highest.setBeamSize(this.highest.getBeamSize() * 1.026f);
                    } else {
                        this.growthStopped = true;
                    }
                }
                ((ServerWorld)player.field_70170_p).field_73004_o = Math.min((float)count / 5.0f, 2.4f);
                ((ServerWorld)player.field_70170_p).field_73017_q = Math.min((float)count / 5.0f, 2.4f);
            }
        } else if (!player.field_70170_p.field_72995_K) {
            int charge;
            if (this.mahoujins == null) {
                this.mahoujins = new ArrayList();
            }
            if (this.target == null) {
                this.target = this.getTargetBlock((PlayerEntity)player);
                this.playerLook = player.field_70177_z;
                this.playerLook = -this.playerLook - 90.0f;
                this.playerPitch = player.field_70125_A;
            }
            if (this.aoeTargets == null) {
                this.aoeTargets = new ArrayList<Vec3d>();
                this.aoeTargets.add(this.getBlockPerpToLook(this.target, this.playerLook, 4.0f));
                this.aoeTargets.add(this.getBlockPerpToLook(this.target, this.playerLook, 8.0f));
                this.aoeTargets.add(this.getBlockPerpToLook(this.target, this.playerLook, -4.0f));
                this.aoeTargets.add(this.getBlockPerpToLook(this.target, this.playerLook, -8.0f));
                this.aoeTargets.add(this.getMiddleCircle(this.target, this.aoeTargets.get(0), this.playerLook, 4.0f));
                this.aoeTargets.add(this.getMiddleCircle(this.target, this.aoeTargets.get(2), this.playerLook, 4.0f));
                this.aoeTargets.add(this.getMiddleCircle(this.aoeTargets.get(0), this.aoeTargets.get(1), this.playerLook, 4.0f));
                this.aoeTargets.add(this.getMiddleCircle(this.aoeTargets.get(2), this.aoeTargets.get(3), this.playerLook, 4.0f));
            }
            if (((charge = this.getRemainingUseDuration(stack, count)) == 1 || charge == 5 || charge == 8 || charge == 13 || charge == 18 || charge == 21 || charge == 26 || charge == 31) && this.aoeSpawnIndex < this.aoeTargets.size()) {
                Vec3d tmp = this.aoeTargets.get(this.aoeSpawnIndex);
                int addone = 1;
                if (this.aoeSpawnIndex > 3) {
                    addone = 0;
                }
                this.createCircleAtAngle((PlayerEntity)player, 1.0f, ((PlayerEntity)player).func_70681_au().nextFloat(), this.playerLook, 85.0f - this.playerPitch, MysticStaff.getDistance(player.func_213303_ch(), this.target) + 1 + addone, tmp, true, 0.1f, true);
                ++this.aoeSpawnIndex;
            } else if (charge > 51) {
                this.growthStopped = true;
            }
        }
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.func_77626_a(stack) - charge;
    }

    public Vec3d getTargetBlock(PlayerEntity player) {
        Vec3d target;
        RayTraceResult result = player.func_213324_a((double)MTConfig.GLOBAL_LOOK_RANGE, 1.0f, false);
        if (result instanceof BlockRayTraceResult) {
            target = new Vec3d((double)((BlockRayTraceResult)result).func_216350_a().func_177958_n() + 0.5, (double)((BlockRayTraceResult)result).func_216350_a().func_177956_o(), (double)((BlockRayTraceResult)result).func_216350_a().func_177952_p() + 0.5);
        } else {
            Vec3d v = player.func_70676_i(0.0f);
            Vec3d v2 = new Vec3d(v.field_72450_a * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72448_b * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72449_c * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3d v3 = player.func_174824_e(0.0f).func_178787_e(v2);
            while (Utils.isBlockAir(player.field_70170_p, new BlockPos(v3)) && v3.field_72448_b > 0.0) {
                v3 = v3.func_178787_e(new Vec3d(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public void createFloorCircle(PlayerEntity player, Vec3d pos, float size, float speed) {
        MysticStaffMahoujinEntity floorMahoujin = new MysticStaffMahoujinEntity(player.field_70170_p, player, false, 0.88f, 0.25f, 0.0f, 0.95f);
        floorMahoujin.func_70107_b(pos.field_72450_a, pos.field_72448_b + 0.001, pos.field_72449_c);
        floorMahoujin.sizer(size);
        floorMahoujin.setRotationSpeed(speed);
        floorMahoujin.setRotationYaw(0.0f);
        floorMahoujin.setRotationPitch(0.0f);
        this.mahoujins.add(floorMahoujin);
        player.field_70170_p.func_217376_c((Entity)floorMahoujin);
    }

    public MysticStaffMahoujinEntity createCircleAtAngle(PlayerEntity player, float size, float speed, float circle, float ground, float distance, Vec3d pos, boolean beam, float beamSize, boolean aoe) {
        MysticStaffMahoujinEntity m;
        if (aoe) {
            m = new MysticStaffMahoujinEntity(player.field_70170_p, player, beam, 0.65f, 0.49f, 0.88f, 0.95f);
            m.setBeamLength(0.0f);
            m.setBeamOffset(0.0f);
        } else {
            m = new MysticStaffMahoujinEntity(player.field_70170_p, player, beam, 0.88f, 0.25f, 0.0f, 0.95f);
            m.setBeamLength(240.0f);
            m.setBeamOffset(-distance);
        }
        m.setDistance(distance);
        m.sizer(size);
        m.setRotationSpeed(speed);
        m.angleCircleAroundBlock(circle, ground, distance, pos);
        this.mahoujins.add(m);
        player.field_70170_p.func_217376_c((Entity)m);
        if (beam) {
            m.setBeamSize(beamSize);
        }
        return m;
    }

    public Vec3d getBlockPerpToLook(Vec3d target, float playerYaw, float distance) {
        float yaw = playerYaw;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(yaw += 90.0f));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(yaw));
        return new Vec3d(plusX, 0.0, plusZ).func_178787_e(target);
    }

    public Vec3d getMiddleCircle(Vec3d target, Vec3d target2, float playerYaw, float distance) {
        double xhalf = (target2.field_72450_a - target.field_72450_a) / 2.0;
        double zhalf = (target2.field_72449_c - target.field_72449_c) / 2.0;
        double plusZ = (double)distance * Math.sin(MysticStaffMahoujinEntity.toRad(playerYaw));
        double plusX = (double)(-distance) * Math.cos(MysticStaffMahoujinEntity.toRad(playerYaw));
        return new Vec3d(plusX += xhalf + target.field_72450_a, target.field_72448_b, plusZ += zhalf + target.field_72449_c);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BOW;
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, LivingEntity caster, int useTicks) {
        PlayerEntity player = (PlayerEntity)caster;
        if (this.mahoujins != null && !world.field_72995_K) {
            int radius = MTConfig.MYSTIC_STAFF_BIG_SIZE;
            if (this.growthStopped) {
                if (!this.getAOEMode(stack)) {
                    if (PlayerManaManager.drainMana(player, MTConfig.MYSTIC_STAFF_BIG_MANA_COST, false, false) == MTConfig.MYSTIC_STAFF_BIG_MANA_COST) {
                        double x = this.target.field_72450_a;
                        double y = this.target.field_72448_b;
                        double z = this.target.field_72449_c;
                        Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y + (float)(radius / 2 + 2), (float)z, MysticStaff.getExplosionDamage(false, Utils.getPlayerMahou((LivingEntity)player)));
                        explosion.explosionA(world, player);
                        ModTriggers.BAKURETSU.trigger((ServerPlayerEntity)player);
                        for (PlayerEntity PlayerEntity2 : world.func_217369_A()) {
                            if (!(PlayerEntity2.func_70092_e(x, y, z) < 16384.0)) continue;
                            Vec3d vec = null;
                            if (explosion.knockback.containsKey(player)) {
                                vec = explosion.knockback.get(player);
                            }
                            if (vec == null) {
                                PacketHandler.sendTo((ServerPlayerEntity)PlayerEntity2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, 0.0f, 0.0f, 0.0f));
                                continue;
                            }
                            PacketHandler.sendTo((ServerPlayerEntity)PlayerEntity2, new BakuretsuPacket(x, y + (double)(radius / 2 + 2), z, radius, (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c));
                        }
                        for (MysticStaffMahoujinEntity e : this.mahoujins) {
                            e.func_70106_y();
                        }
                    }
                } else if (PlayerManaManager.drainMana(player, MTConfig.MYSTIC_STAFF_AOE_MANA_COST, false, false) == MTConfig.MYSTIC_STAFF_AOE_MANA_COST) {
                    int z = 0;
                    for (MysticStaffMahoujinEntity e : this.mahoujins) {
                        e.startShoot(this.aoeTargets.get(z));
                        ++z;
                    }
                }
            }
            this.mahoujins = new ArrayList();
        }
    }

    public static float getExplosionDamage(boolean aoe, IMahou mahou) {
        boolean flat;
        float factor;
        if (aoe) {
            factor = (float)MTConfig.MYSTIC_STAFF_AOE_FACTOR;
            flat = MTConfig.MYSTIC_STAFF_AOE_SCALES;
        } else {
            factor = (float)MTConfig.MYSTIC_STAFF_BIG_FACTOR;
            flat = MTConfig.MYSTIC_STAFF_BIG_SCALES;
        }
        if (!flat && mahou != null) {
            return (float)mahou.getMaxMana() * factor;
        }
        return factor;
    }

    public static List<BlockPos> getAffectedBlocks(World world, BlockPos target, int size) {
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        int r = size / 2;
        Stream box = BlockPos.func_218281_b((BlockPos)target.func_177982_a(-r, -r, -r), (BlockPos)target.func_177982_a(r, r, r));
        box.forEach(tmp -> {
            if (MysticStaff.getDistance(new Vec3d((Vec3i)tmp), new Vec3d((Vec3i)target)) < r) {
                lst.add(new BlockPos(tmp.func_177958_n(), tmp.func_177956_o(), tmp.func_177952_p()));
            }
        });
        return lst;
    }

    public static int getDistance(Vec3d pos1, Vec3d pos2) {
        double x = pos1.field_72450_a - pos2.field_72450_a;
        double y = pos1.field_72448_b - pos2.field_72448_b;
        double z = pos1.field_72449_c - pos2.field_72449_c;
        return (int)Math.abs(Math.ceil(Math.sqrt(x * x + y * y + z * z)));
    }
}

