/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SweepAttackPacket;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class PowerConsolidationSpellEffect {
    public static void powerConsolidationWorldTick(final TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.field_72995_K && event.world.func_72820_D() % (long)MTConfig.POWER_CONSOLIDATION_LAKE_CYCLE == 0L) {
            try {
                final int manaCost = MTConfig.POWER_CONSOLIDATION_SWORD_MANA_COST;
                Iterator iter = ((ServerWorld)event.world).getEntities().iterator();
                double nerfFactor = MTConfig.POWER_CONSOLIDATION_NERF_FACTOR;
                final ArrayList<ItemEntity> toDelete = new ArrayList<ItemEntity>();
                final ArrayList<WeaponProjectileEntity> toSpawn = new ArrayList<WeaponProjectileEntity>();
                while (iter.hasNext()) {
                    ItemStack stack;
                    ICaliburnMahou mahou;
                    PlayerEntity player;
                    ItemEntity item;
                    Entity e = (Entity)iter.next();
                    if (!(e instanceof ItemEntity) || !((item = (ItemEntity)e).func_92059_d().func_77973_b() instanceof SwordItem) || !PowerConsolidationSpellEffect.isItemAllowed(item.func_92059_d()) || !Utils.isInMurkyWater(e) || !item.func_92059_d().func_77948_v() || item.func_200214_m() == null || (player = event.world.func_217371_b(item.func_200214_m())) == null) continue;
                    HashSet<BlockPos> connected = new HashSet<BlockPos>();
                    if (!PowerConsolidationSpellEffect.lakeThreshhold(item.func_180425_c(), connected, event.world)) continue;
                    BlockPos p = PowerConsolidationSpellEffect.findCenter(connected);
                    if (!Utils.isBlockAir(event.world, p)) {
                        p = p.func_177977_b();
                    }
                    if ((mahou = Utils.getCaliburnMahou(stack = new ItemStack((IItemProvider)ModItems.caliburn))) != null) {
                        float damage = Caliburn.simulateHit(item.func_92059_d(), event.world);
                        ItemStack stackCopy = item.func_92059_d().func_77946_l();
                        ListNBT tagList = stackCopy.func_77986_q();
                        tagList.clear();
                        float damageWithoutEnchant = Caliburn.simulateHit(stackCopy, event.world);
                        damage = (float)((double)damage - nerfFactor * (double)(damage - damageWithoutEnchant));
                        mahou.setAttackDamage(damage -= 1.0f);
                        Caliburn.setattacktonbt(stack, event.world);
                    }
                    ModTriggers.SWORD_IN_THE_LAKE.trigger((ServerPlayerEntity)player);
                    WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.world, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), stack);
                    wpe.func_213293_j(0.0, -1.0, 0.0);
                    wpe.func_212361_a((Entity)player);
                    toSpawn.add(wpe);
                    toDelete.add(item);
                }
                ((ServerWorld)event.world).func_73046_m().execute(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < toDelete.size(); ++i) {
                            ItemEntity e = (ItemEntity)toDelete.get(i);
                            if (!e.func_70089_S() || e.func_200214_m() == null || i >= toSpawn.size() || PlayerManaManager.drainMana(event.world.func_217371_b(e.func_200214_m()), manaCost, false, false) != manaCost) continue;
                            event.world.func_217376_c((Entity)toSpawn.get(i));
                            e.func_70106_y();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isItemAllowed(ItemStack s) {
        boolean blacklist = MTConfig.POWER_CONSOLIDATION_CALIBURN_BLACKLIST_TOGGLE;
        ArrayList list = (ArrayList)MTConfig.POWER_CONSOLIDATION_BLACKLIST;
        boolean match = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || s == null || s.func_77973_b().getRegistryName() == null || !((String)list.get(i)).equals(s.func_77973_b().getRegistryName().toString())) continue;
            match = true;
            break;
        }
        if (match && blacklist) {
            return false;
        }
        if (match && !blacklist) {
            return true;
        }
        return !match && blacklist;
    }

    public static BlockPos findCenter(HashSet<BlockPos> connected) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (BlockPos p : connected) {
            if (p.func_177958_n() < minX) {
                minX = p.func_177958_n();
            }
            if (p.func_177958_n() > maxX) {
                maxX = p.func_177958_n();
            }
            if (p.func_177952_p() < minZ) {
                minZ = p.func_177952_p();
            }
            if (p.func_177952_p() > maxZ) {
                maxZ = p.func_177952_p();
            }
            if (p.func_177956_o() <= maxY) continue;
            maxY = p.func_177956_o();
        }
        return new BlockPos(PowerConsolidationSpellEffect.average(maxX, minX), maxY + 1, PowerConsolidationSpellEffect.average(maxZ, minZ));
    }

    public static int average(int a, int b) {
        return (a + b) / 2;
    }

    public static boolean lakeThreshhold(BlockPos p, HashSet<BlockPos> connected, World world) {
        int threshhold = MTConfig.POWER_CONSOLIDATION_LAKE_THRESHHOLD;
        if (connected.size() > threshhold) {
            return true;
        }
        if (connected.contains(p)) {
            return false;
        }
        boolean ret = false;
        if (world != null) {
            if (world.func_180495_p(p).func_177230_c() instanceof MurkyWaterBlock) {
                connected.add(p);
            }
            if (world.func_180495_p(p.func_177984_a()).func_177230_c() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.func_177984_a(), connected, world))) {
                return true;
            }
            if (world.func_180495_p(p.func_177977_b()).func_177230_c() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.func_177977_b(), connected, world))) {
                return true;
            }
            if (world.func_180495_p(p.func_177968_d()).func_177230_c() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.func_177968_d(), connected, world))) {
                return true;
            }
            if (world.func_180495_p(p.func_177976_e()).func_177230_c() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.func_177976_e(), connected, world))) {
                return true;
            }
            if (world.func_180495_p(p.func_177974_f()).func_177230_c() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.func_177974_f(), connected, world))) {
                return true;
            }
            if (world.func_180495_p(p.func_177978_c()).func_177230_c() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.func_177978_c(), connected, world))) {
                return true;
            }
        }
        return ret;
    }

    public static void caliburnLeftClickSpace(PlayerInteractEvent.LeftClickEmpty event) {
        PowerConsolidationSpellEffect.sweepAttack((PlayerInteractEvent)event);
    }

    public static void caliburnLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        PowerConsolidationSpellEffect.sweepAttack((PlayerInteractEvent)event);
    }

    public static void sweepAttack(PlayerInteractEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K && player.func_184614_ca().func_77973_b() instanceof Caliburn) {
            int r = MTConfig.POWER_CONSOLIDATION_SWEEP_RADIUS;
            int r2 = MTConfig.POWER_CONSOLIDATION_SWEEP_LOOK_RADIUS;
            Vec3d p = player.func_174791_d();
            AxisAlignedBB aabb = new AxisAlignedBB(p.func_72441_c((double)(-r), (double)(-r), (double)(-r)), p.func_72441_c((double)r, (double)r, (double)r));
            List lst = player.field_70170_p.func_217357_a(LivingEntity.class, aabb);
            for (LivingEntity e : lst) {
                if (e.func_110124_au().equals(player.func_110124_au()) || !EffectUtil.isLookingAtMe(e, (LivingEntity)player) || !(Math.abs(EffectUtil.pointToLineDistance(e.func_174791_d(), player.func_174824_e(1.0f), player.func_70040_Z().func_178787_e(player.func_174824_e(1.0f)))) < (double)r2)) continue;
                PacketHandler.sendToServer(new SweepAttackPacket((Entity)e));
            }
        }
    }

    public static void powerConsolidationLiquidMovement(TickEvent.WorldTickEvent event) {
    }

    public static void powerConsolidationPlayerLiquidMovement(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70170_p.field_72995_K) {
            PlayerEntity playerEntity = event.player;
        }
    }
}

