/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.util;

import de.melanx.aiotbotania.core.Registration;
import de.melanx.aiotbotania.items.livingrock.ItemLivingrockAIOT;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ToolUtil {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");

    public static void inventoryTick(ItemStack stack, World world, Entity player, int MPD) {
        if (!world.field_72995_K && player instanceof PlayerEntity && stack.func_77952_i() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (PlayerEntity)player, MPD * 2, true)) {
            stack.func_196085_b(stack.func_77952_i() - 1);
        }
    }

    public static boolean hitEntity(ItemStack stack, LivingEntity entity, int MPD) {
        ToolCommons.damageItem((ItemStack)stack, (int)1, (LivingEntity)entity, (int)MPD);
        return true;
    }

    public static boolean onBlockDestroyed(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity, int MPD) {
        if (state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (LivingEntity)entity, (int)MPD);
        }
        return true;
    }

    public static void toggleMode(PlayerEntity player, ItemStack stack) {
        Style dark_blue = new Style().func_150238_a(TextFormatting.DARK_BLUE).func_150217_b(Boolean.valueOf(true));
        Style aqua = new Style().func_150238_a(TextFormatting.AQUA).func_150217_b(Boolean.valueOf(true));
        ITextComponent text = new TranslationTextComponent("aiotbotania.toggleMode", new Object[0]).func_150258_a(" ").func_150255_a(dark_blue);
        ITextComponent utilityMode = new TranslationTextComponent("aiotbotania.utilityMode", new Object[0]).func_150255_a(aqua);
        ITextComponent hoeMode = new TranslationTextComponent("aiotbotania.hoeMode", new Object[0]).func_150255_a(aqua);
        ITextComponent hoeModePath = new TranslationTextComponent("aiotbotania.hoeModePath", new Object[0]).func_150255_a(aqua);
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true)) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)false);
            text.func_150257_a(utilityMode);
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
            if (stack.func_77973_b() instanceof ItemLivingrockAIOT) {
                text = text.func_150257_a(hoeMode);
            } else {
                text.func_150257_a(hoeModePath);
            }
        }
        player.func_146105_b(text, true);
    }

    private static ActionResultType tiltBlock(PlayerEntity player, World world, BlockPos pos, ItemStack stack, BlockState state, int MPD) {
        world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            world.func_175656_a(pos, state);
            ToolCommons.damageItem((ItemStack)stack, (int)1, (LivingEntity)player, (int)MPD);
        }
        return ActionResultType.SUCCESS;
    }

    public static ActionResultType hoemodeUse(@Nonnull ItemUseContext ctx, PlayerEntity player, World world, BlockPos pos, Direction side, Block block, int manaPerDamage) {
        if (!(player.func_213453_ef() || block != Blocks.field_196658_i && block != Blocks.field_150346_d && block != Blocks.field_185774_da)) {
            return ToolUtil.hoeUse(ctx, false, true, manaPerDamage);
        }
        if (side != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a()) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            return ToolUtil.shovelUse(ctx, manaPerDamage);
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType hoeUse(ItemUseContext ctx, boolean special, boolean low_tier, int MPD) {
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        if (player == null || !player.func_175151_a(pos, side, stack)) {
            return ActionResultType.PASS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (side != Direction.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_196658_i || block == Blocks.field_185774_da || block == Blocks.field_150346_d) {
                BlockState farmland = special ? ((Block)Registration.custom_farmland.get()).func_176223_P() : Blocks.field_150458_ak.func_176223_P();
                return ToolUtil.tiltBlock(player, world, pos, stack, farmland, MPD);
            }
            if (block instanceof FarmlandBlock && special) {
                Block block1 = Blocks.field_196658_i;
                return ToolUtil.tiltBlock(player, world, pos, stack, block1.func_176223_P(), MPD);
            }
            if (block instanceof FarmlandBlock && !low_tier) {
                Block block1 = Blocks.field_150346_d;
                return ToolUtil.tiltBlock(player, world, pos, stack, block1.func_176223_P(), MPD);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public static ActionResultType pickUse(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !TORCH_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
                ActionResultType did = PlayerHelper.substituteUse((ItemUseContext)ctx, (ItemStack)stackAt);
                if (did == ActionResultType.SUCCESS && !ctx.func_195991_k().func_201670_d()) {
                    ItemsRemainingRenderHandler.send((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_150478_aa), (Pattern)TORCH_PATTERN);
                }
                return did;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public static ActionResultType axeUse(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt = player.field_71071_by.func_70301_a(i);
                if (stackAt.func_190926_b() || !SAPLING_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
                ActionResultType did = PlayerHelper.substituteUse((ItemUseContext)ctx, (ItemStack)stackAt);
                if (did == ActionResultType.SUCCESS && !ctx.func_195991_k().func_201670_d()) {
                    ItemsRemainingRenderHandler.send((PlayerEntity)player, (ItemStack)new ItemStack((IItemProvider)Blocks.field_196674_t), (Pattern)SAPLING_PATTERN);
                }
                return did;
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType shovelUse(ItemUseContext ctx, int MPD) {
        ItemStack stack = ctx.func_195996_i();
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (player != null && player.func_175151_a(pos, ctx.func_196000_l(), stack)) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (ctx.func_196000_l() != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a()) && (block == Blocks.field_196658_i || block == Blocks.field_150346_d)) {
                Block block1 = Blocks.field_185774_da;
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, block1.func_176223_P());
                    ToolCommons.damageItem((ItemStack)stack, (int)1, (LivingEntity)player, (int)MPD);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }
}

