/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.elementium;

import com.google.common.collect.Multimap;
import de.melanx.aiotbotania.items.ItemTiers;
import de.melanx.aiotbotania.items.base.ItemAIOTBase;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemElementiumAIOT
extends ItemAIOTBase {
    private static final int MANA_PER_DAMAGE = 66;
    private static final float DAMAGE = 6.0f;
    private static final float SPEED = -2.2f;
    private static final Tag<Item> DISPOSABLE = new ItemTags.Wrapper(new ResourceLocation("botania", "disposable"));
    private static final Tag<Item> SEMI_DISPOSABLE = new ItemTags.Wrapper(new ResourceLocation("botania", "semi_disposable"));

    public ItemElementiumAIOT() {
        super(ItemTiers.ELEMENTIUM_AIOT_ITEM_TIER, 6.0f, -2.2f, 66, true);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityDrops);
        MinecraftForge.EVENT_BUS.addListener(this::onHarvestDrops);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        Multimap ret = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE.func_111108_a(), (Object)PixieHandler.makeModifier((EquipmentSlotType)slot, (String)"AIOT modifier", (double)0.1));
        }
        return ret;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        Material mat = world.func_180495_p(pos).func_185904_a();
        if (!ToolCommons.materialsShovel.contains(mat)) {
            return false;
        }
        Block blk = world.func_180495_p(pos).func_177230_c();
        if (blk instanceof FallingBlock) {
            ToolCommons.removeBlocksInIteration((PlayerEntity)player, (ItemStack)stack, (World)world, (BlockPos)pos, (Vec3i)new Vec3i(0, -12, 0), (Vec3i)new Vec3i(1, 12, 1), state -> state.func_177230_c() == blk, (boolean)false);
        }
        return false;
    }

    private void onEntityDrops(LivingDropsEvent e) {
        ItemStack weapon;
        if (e.isRecentlyHit() && e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof PlayerEntity && !(weapon = ((PlayerEntity)e.getSource().func_76346_g()).func_184614_ca()).func_190926_b() && weapon.func_77973_b() == this) {
            Random rand = e.getEntityLiving().field_70170_p.field_73012_v;
            int looting = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)weapon);
            if (e.getEntityLiving() instanceof AbstractSkeletonEntity && rand.nextInt(26) <= 3 + looting) {
                this.addDrop(e, new ItemStack((IItemProvider)(e.getEntity() instanceof WitherSkeletonEntity ? Items.field_196183_dw : Items.field_196182_dv)));
            } else if (e.getEntityLiving() instanceof ZombieEntity && !(e.getEntityLiving() instanceof ZombiePigmanEntity) && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(e, new ItemStack((IItemProvider)Items.field_196186_dz));
            } else if (e.getEntityLiving() instanceof CreeperEntity && rand.nextInt(26) <= 2 + 2 * looting) {
                this.addDrop(e, new ItemStack((IItemProvider)Items.field_196185_dy));
            } else if (e.getEntityLiving() instanceof PlayerEntity && rand.nextInt(11) <= 1 + looting) {
                ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx);
                ItemNBTHelper.setString((ItemStack)stack, (String)"SkullOwner", (String)((PlayerEntity)e.getEntityLiving()).func_146103_bH().getName());
                this.addDrop(e, stack);
            } else if (e.getEntityLiving() instanceof EntityDoppleganger && rand.nextInt(13) < 1 + looting) {
                this.addDrop(e, new ItemStack((IItemProvider)ModBlocks.gaiaHead));
            }
        }
    }

    private void addDrop(LivingDropsEvent e, ItemStack drop) {
        ItemEntity entityitem = new ItemEntity(e.getEntityLiving().field_70170_p, e.getEntityLiving().field_70142_S, e.getEntityLiving().field_70137_T, e.getEntityLiving().field_70136_U, drop);
        entityitem.func_174867_a(10);
        e.getDrops().add(entityitem);
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent e) {
        ItemStack stack;
        if (e.getHarvester() != null && !(stack = e.getHarvester().func_184614_ca()).func_190926_b() && stack.func_77973_b() == this) {
            e.getDrops().removeIf(s -> !s.func_190926_b() && (ItemElementiumAIOT.isDisposable(s) || ItemElementiumAIOT.isSemiDisposable(s)) && !e.getHarvester().func_213453_ef());
        }
    }

    public static boolean isDisposable(Block block) {
        return DISPOSABLE.func_199685_a_((Object)block.func_199767_j());
    }

    private static boolean isDisposable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return DISPOSABLE.func_199685_a_((Object)stack.func_77973_b());
    }

    private static boolean isSemiDisposable(ItemStack stack) {
        return SEMI_DISPOSABLE.func_199685_a_((Object)stack.func_77973_b());
    }
}

