/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.handler;

import java.util.Objects;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.api.network.IFluxTransfer;
import sonar.fluxnetworks.common.connection.handler.AbstractPointHandler;
import sonar.fluxnetworks.common.connection.transfer.SidedTransfers;
import sonar.fluxnetworks.common.tileentity.TileFluxPoint;

public class FluxPointHandler
extends AbstractPointHandler<TileFluxPoint> {
    public SidedTransfers transfers;

    public FluxPointHandler(TileFluxPoint fluxPoint) {
        super(fluxPoint);
        this.transfers = new SidedTransfers(fluxPoint);
    }

    @Override
    public void onStartCycle() {
        super.onStartCycle();
        this.transfers.getTransfers().stream().filter(Objects::nonNull).forEach(IFluxTransfer::onStartCycle);
    }

    @Override
    public void onEndCycle() {
        super.onEndCycle();
        this.transfers.getTransfers().stream().filter(Objects::nonNull).forEach(IFluxTransfer::onEndCycle);
    }

    @Override
    public long removeEnergy(long energy, boolean simulate) {
        if (!((TileFluxPoint)this.fluxConnector).isActive()) {
            return 0L;
        }
        long remove = 0L;
        for (IFluxTransfer transfer : this.transfers.getTransfers()) {
            if (transfer == null) continue;
            long toTransfer = energy - remove;
            remove += transfer.addEnergy(toTransfer, simulate);
        }
        if (!simulate) {
            this.removedFromBuffer += remove;
        }
        return remove;
    }

    @Override
    public void updateTransfers(Direction ... faces) {
        this.transfers.updateTransfers(faces);
    }
}

