/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.render.FluxRenderTypes;
import sonar.fluxnetworks.common.tileentity.TileFluxStorage;

public class FluxStorageTileRenderer
extends TileEntityRenderer<TileFluxStorage> {
    public static final float startX = 0.125f;
    public static final float startY = 0.125f;
    public static final float offsetZ = 0.0625f;
    public static final float width = 0.75f;
    public static final float height = 0.8125f;
    public static final float alpha = 0.5882353f;
    public static final int maxLight = 0xF000F0;

    public FluxStorageTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileFluxStorage tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluxStorageTileRenderer.render(partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, tile.energyStored, tile.maxEnergyStorage, tile.color | 0xFF000000);
    }

    public static void render(float partialTicks, MatrixStack matrix, IRenderTypeBuffer bufferIn, int light, int overlay, int energyStored, int energyMax, int networkColour) {
        if (energyStored == 0 || energyMax == 0) {
            return;
        }
        float r = ScreenUtils.getRed(networkColour);
        float g = ScreenUtils.getGreen(networkColour);
        float b = ScreenUtils.getBlue(networkColour);
        float energyPercentage = (float)energyStored / (float)energyMax;
        float renderHeight = 0.8125f * energyPercentage;
        float renderWidth = 0.75f;
        IVertexBuilder builder = bufferIn.getBuffer(FluxRenderTypes.FLUX_STORAGE_GLOW);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.NORTH, 0.125f, 0.125f, 0.0625f, renderWidth, renderHeight, r, g, b, 0.5882353f, 0xF000F0, overlay, energyPercentage);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.SOUTH, 0.125f, 0.125f, 0.0625f, renderWidth, renderHeight, r, g, b, 0.5882353f, 0xF000F0, overlay, energyPercentage);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.EAST, 0.125f, 0.125f, 0.0625f, renderWidth, renderHeight, r, g, b, 0.5882353f, 0xF000F0, overlay, energyPercentage);
        FluxStorageTileRenderer.renderSide(matrix, builder, Direction.WEST, 0.125f, 0.125f, 0.0625f, renderWidth, renderHeight, r, g, b, 0.5882353f, 0xF000F0, overlay, energyPercentage);
        if (energyPercentage != 1.0f) {
            FluxStorageTileRenderer.renderSide(matrix, builder, Direction.DOWN, 0.0625f, 0.0625f, 0.875f - renderHeight, 0.875f, 0.875f, r, g, b, 0.5882353f, 0xF000F0, overlay, energyPercentage);
        }
    }

    public static void renderSide(MatrixStack matrix, IVertexBuilder builder, Direction dir, float x, float y, float z, float width, float height, float r, float g, float b, float a, int light, int overlay, float fillPercentage) {
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 1.0f;
        float maxV = 1.0f * fillPercentage;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(dir.func_229384_a_());
        matrix.func_227863_a_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
        matrix.func_227861_a_(-0.5, -0.5, -0.5);
        Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
        Matrix3f normal = matrix.func_227866_c_().func_227872_b_();
        builder.func_227888_a_(matrix4f, x, y + height, z).func_227885_a_(r, g, b, a).func_225583_a_(minU, maxV).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y + height, z).func_227885_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x + width, y, z).func_227885_a_(r, g, b, a).func_225583_a_(maxU, minV).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(minU, minV).func_227891_b_(overlay).func_227886_a_(light).func_227887_a_(normal, 0.0f, 0.0f, 0.0f).func_181675_d();
        matrix.func_227865_b_();
    }
}

