/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import xreliquary.init.ModBlocks;
import xreliquary.items.block.BlockItemBase;
import xreliquary.reference.Settings;

public class FertileLilyPadItem
extends BlockItemBase {
    public FertileLilyPadItem() {
        super((Block)ModBlocks.FERTILE_LILY_PAD, new Item.Properties().func_208103_a(Rarity.EPIC));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        RayTraceResult raytraceresult = FertileLilyPadItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ItemStack stack = player.func_184586_b(hand);
        if (this.tryPlacingLilyPad(stack, world, player, raytraceresult)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    private boolean tryPlacingLilyPad(ItemStack itemStack, World world, PlayerEntity playerIn, RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            return true;
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
            BlockPos blockpos = blockraytraceresult.func_216350_a();
            Direction direction = blockraytraceresult.func_216354_b();
            if (!world.func_175660_a(playerIn, blockpos) || !playerIn.func_175151_a(blockpos.func_177972_a(direction), direction, itemStack)) {
                return false;
            }
            BlockPos posUp = blockpos.func_177984_a();
            BlockState blockstate = world.func_180495_p(blockpos);
            Material material = blockstate.func_185904_a();
            IFluidState ifluidstate = world.func_204610_c(blockpos);
            if ((ifluidstate.func_206886_c() == Fluids.field_204546_a || material == Material.field_151588_w) && world.func_175623_d(posUp)) {
                return this.placeAndShrinkStack(itemStack, world, playerIn, blockpos, posUp);
            }
        }
        return false;
    }

    private boolean placeAndShrinkStack(ItemStack itemStack, World worldIn, PlayerEntity playerIn, BlockPos blockpos, BlockPos posUp) {
        BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((IWorld)worldIn, (BlockPos)posUp);
        worldIn.func_180501_a(posUp, ModBlocks.FERTILE_LILY_PAD.func_176223_P(), 11);
        if (ForgeEventFactory.onBlockPlace((Entity)playerIn, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
            blocksnapshot.restore(true, false);
            return false;
        }
        int secondsBetweenGrowthTicks = (Integer)Settings.COMMON.blocks.fertileLilypad.secondsBetweenGrowthTicks.get();
        worldIn.func_205220_G_().func_205360_a(posUp, (Object)ModBlocks.FERTILE_LILY_PAD, secondsBetweenGrowthTicks * 20);
        if (playerIn instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, posUp, itemStack);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        worldIn.func_184133_a(playerIn, blockpos, SoundEvents.field_187916_gp, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }
}

