/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.potion;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import xreliquary.entities.potion.ThrownPotionEntity;
import xreliquary.init.ModEntities;
import xreliquary.init.ModItems;
import xreliquary.items.util.IPotionItem;
import xreliquary.network.PacketFXThrownPotionImpact;
import xreliquary.network.PacketHandler;
import xreliquary.util.potions.XRPotionHelper;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class ThrownXRPotionEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData,
IRendersAsItem {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(ThrownPotionEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    public ThrownXRPotionEntity(EntityType<ThrownXRPotionEntity> entityType, World world) {
        super(entityType, world);
    }

    public ThrownXRPotionEntity(World world, double x, double y, double z, ItemStack potion) {
        super(ModEntities.THROWN_POTION, x, y, z, world);
        this.setItem(potion);
    }

    public ThrownXRPotionEntity(World world, LivingEntity entity, ItemStack potion) {
        super(ModEntities.THROWN_POTION, entity, world);
        this.setItem(potion);
    }

    protected float func_70185_h() {
        return 0.04f;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack potion = this.func_184543_l();
            if (!(potion.func_77973_b() instanceof IPotionItem)) {
                return;
            }
            List<EffectInstance> effects = ((IPotionItem)potion.func_77973_b()).getEffects(potion);
            int color = PotionUtils.func_185181_a(effects);
            if (potion.func_77973_b() == ModItems.LINGERING_POTION) {
                this.spawnAreaEffectCloud(effects, color);
            } else {
                this.splashPotion(result, effects);
            }
            this.spawnParticles(color);
            this.func_70106_y();
        }
    }

    private void splashPotion(RayTraceResult result, List<EffectInstance> effects) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List livingEntities = this.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb);
        if (!livingEntities.isEmpty()) {
            for (LivingEntity entity : livingEntities) {
                double d0 = this.func_70032_d((Entity)entity);
                if (!(d0 < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY && entity == ((EntityRayTraceResult)result).func_216348_a()) {
                    d1 = 1.0;
                }
                XRPotionHelper.applyEffectsToEntity(effects, (Entity)this, (Entity)this.func_85052_h(), entity, d1);
            }
        }
    }

    private void spawnAreaEffectCloud(List<EffectInstance> effects, int color) {
        AreaEffectCloudEntity areaEffectCloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaEffectCloud.func_184481_a(this.func_85052_h());
        areaEffectCloud.func_184483_a(3.0f);
        areaEffectCloud.func_184495_b(-0.5f);
        areaEffectCloud.func_184485_d(10);
        areaEffectCloud.func_184487_c(-areaEffectCloud.func_184490_j() / (float)areaEffectCloud.func_184489_o());
        areaEffectCloud.func_184482_a(color);
        for (EffectInstance potionEffect : effects) {
            areaEffectCloud.func_184496_a(new EffectInstance(potionEffect.func_188419_a(), potionEffect.func_76459_b(), potionEffect.func_76458_c()));
        }
        this.field_70170_p.func_217376_c((Entity)areaEffectCloud);
    }

    private void spawnParticles(int color) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Random var7 = this.field_70146_Z;
        for (int var15 = 0; var15 < 8; ++var15) {
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184543_l()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15);
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        PacketHandler.sendToAllAround(new PacketFXThrownPotionImpact(color, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), new PacketDistributor.TargetPoint(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 32.0, this.field_70170_p.func_201675_m().func_186058_p()));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("item", (INBT)this.func_184543_l().func_77955_b(new CompoundNBT()));
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setItem(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item")));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184543_l() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    private void setItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(ITEM, (Object)stack);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150788_a(this.func_184543_l());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.setItem(additionalData.func_150791_c());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

