/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.curios;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;
import top.theillusivec4.curios.api.inventory.CurioStackHandler;
import xreliquary.client.render.MobCharmBeltLayerRenderer;
import xreliquary.compat.ICompat;
import xreliquary.compat.curios.CuriosBaubleItemWrapper;
import xreliquary.compat.curios.CuriosCharmInventoryHandler;
import xreliquary.compat.curios.CuriosFortuneCoinToggler;
import xreliquary.init.ModItems;
import xreliquary.items.util.IBaubleItem;
import xreliquary.util.InventoryHelper;

public class CuriosCompat
implements ICompat {
    public CuriosCompat() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::sendImc);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::registerModels));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage(IBaubleItem.Type.NECKLACE.getIdentifier()));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage(IBaubleItem.Type.BODY.getIdentifier()));
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage(IBaubleItem.Type.BELT.getIdentifier()));
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        final Item item = stack.func_77973_b();
        if (item.getRegistryName() != null && item.getRegistryName().func_110624_b().equals("xreliquary") && item instanceof IBaubleItem) {
            evt.addCapability(new ResourceLocation("xreliquary", item.getRegistryName().func_110623_a() + "_curios"), new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> new CuriosBaubleItemWrapper((IBaubleItem)item)));
                }
            });
        }
    }

    @Override
    public void setup() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> new CuriosFortuneCoinToggler().registerSelf());
        ModItems.MOB_CHARM.setCharmInventoryHandler(new CuriosCharmInventoryHandler());
        InventoryHelper.addBaublesItemHandlerFactory((player, type) -> (CurioStackHandler)CuriosAPI.getCuriosHandler((LivingEntity)player).map(handler -> handler.getStackHandler(type.getIdentifier())).filter(Objects::nonNull).orElse((Object)new CurioStackHandler()));
    }

    public static Optional<ItemStack> getStackInSlot(LivingEntity entity, String slotName, int slot) {
        return (Optional)CuriosAPI.getCuriosHandler((LivingEntity)entity).map(handler -> Optional.of(handler.getStackHandler(slotName).getStackInSlot(slot))).orElse(Optional.empty());
    }

    public static void setStackInSlot(LivingEntity entity, String slotName, int slot, ItemStack stack) {
        CuriosAPI.getCuriosHandler((LivingEntity)entity).ifPresent(handler -> handler.getStackHandler(slotName).setStackInSlot(slot, stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerModels(ModelRegistryEvent event) {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new MobCharmBeltLayerRenderer((LivingRenderer)render){

            @Override
            protected IItemHandler getBaublesHandler(PlayerEntity player) {
                return (IItemHandler)CuriosAPI.getCuriosHandler((LivingEntity)player).map(h -> h.getStackHandler(IBaubleItem.Type.BELT.getIdentifier())).orElse((Object)new CurioStackHandler());
            }
        });
    }
}

