/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.lib.util.MCMathUtils;

public final class WorldUtils {
    private WorldUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> Map<BlockPos, T> getBlocksInArea(World world, BlockPos pos, int range, BiFunction<World, BlockPos, Optional<T>> getter) {
        int xMin = pos.func_177958_n() - range;
        int xMax = pos.func_177958_n() + range;
        int yMin = pos.func_177956_o() - range;
        int yMax = pos.func_177956_o() + range;
        int zMin = pos.func_177952_p() - range;
        int zMax = pos.func_177952_p() + range;
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, getter);
    }

    public static <T> Map<BlockPos, T> getBlocksInSphere(World world, BlockPos pos, int radius, BiFunction<World, BlockPos, Optional<T>> getter) {
        int radiusSq = radius * radius;
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int yMin = pos.func_177956_o() - radius;
        int yMax = pos.func_177956_o() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, (world1, pos1) -> {
            if (MCMathUtils.distanceSq((Vec3i)pos, (Vec3i)pos1) <= (double)radiusSq) {
                return (Optional)getter.apply((World)world1, (BlockPos)pos1);
            }
            return Optional.empty();
        });
    }

    public static <T> Map<BlockPos, T> getBlocks(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BiFunction<World, BlockPos, Optional<T>> getter) {
        LinkedHashMap map = new LinkedHashMap();
        if (!world.func_217344_a(xMin, yMin, zMin, xMax, yMax, zMax)) {
            return map;
        }
        try (BlockPos.PooledMutable blockPos = BlockPos.PooledMutable.func_185346_s();){
            for (int x = xMin; x <= xMax; ++x) {
                for (int y = yMin; y <= yMax; ++y) {
                    for (int z = zMin; z <= zMax; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        getter.apply(world, (BlockPos)blockPos.func_181079_c(x, y, z)).ifPresent(t -> map.put(pos, t));
                    }
                }
            }
        }
        return map;
    }

    public static <T extends TileEntity> Map<BlockPos, T> getTileEntitiesInArea(Class<? extends T> clazz, World world, BlockPos pos, int range) {
        int xMin = pos.func_177958_n() - range;
        int xMax = pos.func_177958_n() + range;
        int yMin = pos.func_177956_o() - range;
        int yMax = pos.func_177956_o() + range;
        int zMin = pos.func_177952_p() - range;
        int zMax = pos.func_177952_p() + range;
        return WorldUtils.getTileEntities(clazz, world, xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public static <T extends TileEntity> Map<BlockPos, T> getTileEntitiesInSphere(Class<? extends T> clazz, World world, BlockPos pos, int radius) {
        int radiusSq = radius * radius;
        int xMin = pos.func_177958_n() - radius;
        int xMax = pos.func_177958_n() + radius;
        int yMin = pos.func_177956_o() - radius;
        int yMax = pos.func_177956_o() + radius;
        int zMin = pos.func_177952_p() - radius;
        int zMax = pos.func_177952_p() + radius;
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, (world1, pos1) -> {
            if (MCMathUtils.distanceSq((Vec3i)pos, (Vec3i)pos1) <= (double)radiusSq) {
                return WorldUtils.getTileEntityOfType(clazz, pos, (IBlockReader)world1);
            }
            return Optional.empty();
        });
    }

    public static <T extends TileEntity> Map<BlockPos, T> getTileEntities(Class<? extends T> clazz, World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        return WorldUtils.getBlocks(world, xMin, yMin, zMin, xMax, yMax, zMax, (world1, pos) -> WorldUtils.getTileEntityOfType(clazz, pos, (IBlockReader)world1));
    }

    private static <T extends TileEntity> Optional<T> getTileEntityOfType(Class<? extends T> clazz, BlockPos pos, IBlockReader world) {
        TileEntity te = world.func_175625_s(pos);
        return clazz.isInstance(te) ? Optional.of(te) : Optional.empty();
    }
}

