/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.shedaniel.forge.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FloatListListEntry
extends AbstractTextFieldListListEntry<Float, FloatListCell, FloatListListEntry> {
    private float minimum = Float.NEGATIVE_INFINITY;
    private float maximum = Float.POSITIVE_INFINITY;

    @Deprecated
    public FloatListListEntry(String fieldName, List<Float> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, String resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    public FloatListListEntry(String fieldName, List<Float> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, String resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    public FloatListListEntry(String fieldName, List<Float> value, boolean defaultExpanded, Supplier<Optional<String[]>> tooltipSupplier, Consumer<List<Float>> saveConsumer, Supplier<List<Float>> defaultValue, String resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, FloatListCell::new);
    }

    public FloatListListEntry setMaximum(float maximum) {
        this.maximum = maximum;
        return this;
    }

    public FloatListListEntry setMinimum(float minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public FloatListListEntry self() {
        return this;
    }

    public static class FloatListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Float, FloatListCell, FloatListListEntry> {
        public FloatListCell(Float value, FloatListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Float substituteDefault(@Nullable Float value) {
            if (value == null) {
                return Float.valueOf(0.0f);
            }
            return value;
        }

        @Override
        protected boolean isValidText(String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45 || c == 46);
        }

        @Override
        public Float getValue() {
            try {
                return Float.valueOf(this.widget.func_146179_b());
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }

        @Override
        public Optional<String> getError() {
            try {
                float i = Float.parseFloat(this.widget.func_146179_b());
                if (i > ((FloatListListEntry)this.listListEntry).maximum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{Float.valueOf(((FloatListListEntry)this.listListEntry).maximum)}));
                }
                if (i < ((FloatListListEntry)this.listListEntry).minimum) {
                    return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{Float.valueOf(((FloatListListEntry)this.listListEntry).minimum)}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.not_valid_number_float", (Object[])new Object[0]));
            }
            return Optional.empty();
        }
    }
}

