/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp.util;

import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tk.dczippl.lightestlamp.util.IFluidHandlerWrapper;

public class FluidHandlerWrapper
implements IFluidHandler {
    public IFluidHandlerWrapper wrapper;
    public Direction side;

    public FluidHandlerWrapper(IFluidHandlerWrapper w, Direction s) {
        this.wrapper = w;
        this.side = s;
    }

    public int getTanks() {
        return this.wrapper.getAllTanks().length;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.wrapper.getAllTanks()[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.wrapper.getAllTanks()[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.wrapper.getAllTanks()[tank].isFluidValid(stack);
    }

    public int fill(@Nonnull FluidStack resource, IFluidHandler.FluidAction fluidAction) {
        if (this.side == null || resource.isEmpty()) {
            return 0;
        }
        if (this.wrapper.canFill(this.side, resource)) {
            return this.wrapper.fill(this.side, resource, fluidAction);
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(@Nonnull FluidStack resource, IFluidHandler.FluidAction fluidAction) {
        if (this.side == null || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.wrapper.canDrain(this.side, resource)) {
            return this.wrapper.drain(this.side, resource, fluidAction);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
        if (this.side == null) {
            return FluidStack.EMPTY;
        }
        if (this.wrapper.canDrain(this.side, FluidStack.EMPTY)) {
            return this.wrapper.drain(this.side, maxDrain, fluidAction);
        }
        return FluidStack.EMPTY;
    }
}

