/*
 * Decompiled with CFR 0.152.
 */
package tk.dczippl.lightestlamp;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tk.dczippl.lightestlamp.Config;
import tk.dczippl.lightestlamp.init.ModBlocks;
import tk.dczippl.lightestlamp.init.ModContainers;
import tk.dczippl.lightestlamp.init.ModEffect;
import tk.dczippl.lightestlamp.init.ModFluids;
import tk.dczippl.lightestlamp.init.ModItems;
import tk.dczippl.lightestlamp.init.ModTileEntities;
import tk.dczippl.lightestlamp.machine.gascentrifuge.GasCentrifugeScreen;
import tk.dczippl.lightestlamp.machine.gascentrifuge.GasCentrifugeTile;
import tk.dczippl.lightestlamp.tile.AbyssalLanternTileEntity;
import tk.dczippl.lightestlamp.tile.AlchemicalLampTileEntity;
import tk.dczippl.lightestlamp.tile.AlfaLampTileEntity;
import tk.dczippl.lightestlamp.tile.AntiLampTileEntity;
import tk.dczippl.lightestlamp.tile.BetaLampTileEntity;
import tk.dczippl.lightestlamp.tile.ClearLampTileEntity;
import tk.dczippl.lightestlamp.tile.ClearSeaLanternTileEntity;
import tk.dczippl.lightestlamp.tile.DeepOceanLanternTileEntity;
import tk.dczippl.lightestlamp.tile.DeepSeaLanternTileEntity;
import tk.dczippl.lightestlamp.tile.DeltaLampTileEntity;
import tk.dczippl.lightestlamp.tile.EpsilonLampTileEntity;
import tk.dczippl.lightestlamp.tile.EtaLampTileEntity;
import tk.dczippl.lightestlamp.tile.GammaLampTileEntity;
import tk.dczippl.lightestlamp.tile.LightAirTileEntity;
import tk.dczippl.lightestlamp.tile.OceanLanternTileEntity;
import tk.dczippl.lightestlamp.tile.OmegaChunkCleanerTileEntity;
import tk.dczippl.lightestlamp.tile.OmegaLampTileEntity;
import tk.dczippl.lightestlamp.tile.ZetaLampTileEntity;
import tk.dczippl.lightestlamp.util.WorldGenerator;
import tk.dczippl.lightestlamp.util.network.Networking;

@Mod(value="lightestlamp")
public class Main {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup main_group = new ItemGroup("lamps"){

        public ItemStack func_78016_d() {
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.OMEGA_LAMP);
            return stack;
        }
    };

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModFluids.BLOCKS.register(modEventBus);
        ModFluids.ITEMS.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("lightestlamp-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("lightestlamp-common.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        WorldGenerator.setupWorldGeneraton();
        Networking.registerMessages();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(ModContainers.GAS_CENTRIFUGE, GasCentrifugeScreen::new);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.JUNGLE_LANTERN, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.GLOWING_GLASS_BLOCK, (RenderType)RenderType.func_228643_e_());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        Random rnd;
        if (event.getSource().func_76355_l().equals("player") && event.getEntityLiving() instanceof IMob && event.getEntityLiving().func_130014_f_().func_130001_d() == 1.0f && (rnd = new Random()).nextInt(4) == 2) {
            event.getEntityLiving().func_199701_a_(new ItemStack((IItemProvider)ModItems.MOON_SHARD));
        }
    }

    @SubscribeEvent
    public void EntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        boolean disabled = false;
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_175149_v()) {
            disabled = true;
        }
        if (!disabled) {
            BlockPos pos = entity.func_180425_c();
            Block b = entity.func_130014_f_().func_180495_p(pos.func_177972_a(Direction.UP)).func_177230_c();
            Block b1 = entity.func_130014_f_().func_180495_p(pos).func_177230_c();
            if (b.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
                entity.func_213317_d(new Vec3d(entity.func_213322_ci().field_72450_a, 0.10000001162, entity.func_213322_ci().field_72449_c));
            } else if (b1.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
                entity.func_213317_d(new Vec3d(entity.func_213322_ci().field_72450_a, 0.10000001162, entity.func_213322_ci().field_72449_c));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void setFog(EntityViewRenderEvent.FogColors fog) {
        BlockPos pos;
        World w = fog.getInfo().func_216773_g().func_130014_f_();
        BlockState bs = w.func_180495_p(pos = fog.getInfo().func_216780_d());
        Block b = bs.func_177230_c();
        if (b.equals(ModFluids.BROMINE_FLUID_BLOCK.get())) {
            float red = 0.2f;
            float green = 0.05f;
            float blue = 0.05f;
            fog.setRed(red);
            fog.setGreen(green);
            fog.setBlue(blue);
        }
    }

    public static void repelEntitiesInAABBFromPoint(World world, AxisAlignedBB effectBounds, double x, double y, double z, boolean ignore) {
        List list = world.func_217357_a(Entity.class, effectBounds);
        for (Entity ent : list) {
            if (!(ent instanceof LivingEntity) && !(ent instanceof IProjectile) || !ignore && !(ent instanceof IMob) && !(ent instanceof IProjectile) || ent instanceof ArrowEntity && ((ArrowEntity)ent).field_70122_E) continue;
            Vec3d p = new Vec3d(x, y, z);
            Vec3d t = ent.func_213303_ch();
            double distance = p.func_72438_d(t) + 0.1;
            Vec3d r = new Vec3d(t.field_72450_a - p.field_72450_a, t.field_72448_b - p.field_72448_b, t.field_72449_c - p.field_72449_c);
            ent.func_213293_j(r.field_72450_a / 1.5 / distance + ent.func_213322_ci().field_72450_a, r.field_72448_b / 1.5 / distance + ent.func_213322_ci().field_72448_b, r.field_72449_c / 1.5 / distance + ent.func_213322_ci().field_72449_c);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ANTI_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ALCHEMICAL_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.LIGHT_AIR);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.WATERLOGGABLE_LIGHT_AIR);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.CLEAR_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ALFA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.BETA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.GAMMA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.DELTA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.EPSILON_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ZETA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ETA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.OMEGA_LAMP);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.CLEAR_SEA_LANTERN);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.DEEP_SEA_LANTERN);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.OCEAN_LANTERN);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.DEEP_OCEAN_LANTERN);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ABYSSAL_LANTERN);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.GLOWING_GLASS_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.DARK_AIR);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.JUNGLE_LANTERN);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.GAS_EXTRACTOR);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.NEON_ROD_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ARGON_ROD_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.KRYPTON_ROD_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.XENON_ROD_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.RADON_ROD_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.NEON_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.ARGON_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.KRYPTON_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.XENON_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.RADON_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.CHUNK_CLEANER);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.VANTA_BLACK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.BORON_ORE);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.LUMINATIUM_BLOCK);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModBlocks.OCC);
        }

        @SubscribeEvent
        public static void registerEffects(RegistryEvent.Register<Effect> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Effect[]{ModEffect.BROMINE_POISON});
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> containerTypeRegistryEvent) {
            containerTypeRegistryEvent.getRegistry().register(ModContainers.GAS_CENTRIFUGE);
        }

        @SubscribeEvent
        public static void registerTE(RegistryEvent.Register<TileEntityType<?>> evt) {
            evt.getRegistry().register(TileEntityType.Builder.func_223042_a(LightAirTileEntity::new, (Block[])new Block[]{ModBlocks.LIGHT_AIR, ModBlocks.CHUNK_CLEANER}).func_206865_a(null).setRegistryName("light_air_te"));
            evt.getRegistry().register(TileEntityType.Builder.func_223042_a(AntiLampTileEntity::new, (Block[])new Block[]{ModBlocks.ANTI_LAMP}).func_206865_a(null).setRegistryName("antilamp_te"));
            TileEntityType clear_te = TileEntityType.Builder.func_223042_a(ClearLampTileEntity::new, (Block[])new Block[]{ModBlocks.CLEAR_LAMP}).func_206865_a(null);
            clear_te.setRegistryName("lightestlamp", "clear_te");
            ModTileEntities.CLEAR_TE = clear_te;
            evt.getRegistry().register(ModTileEntities.CLEAR_TE);
            TileEntityType type0 = TileEntityType.Builder.func_223042_a(AlfaLampTileEntity::new, (Block[])new Block[]{ModBlocks.ALFA_LAMP}).func_206865_a(null);
            type0.setRegistryName("lightestlamp", "alfa_te");
            TileEntityType type1 = TileEntityType.Builder.func_223042_a(BetaLampTileEntity::new, (Block[])new Block[]{ModBlocks.BETA_LAMP}).func_206865_a(null);
            type1.setRegistryName("lightestlamp", "beta_te");
            TileEntityType type2 = TileEntityType.Builder.func_223042_a(GammaLampTileEntity::new, (Block[])new Block[]{ModBlocks.GAMMA_LAMP}).func_206865_a(null);
            type2.setRegistryName("lightestlamp", "gamma_te");
            TileEntityType type3 = TileEntityType.Builder.func_223042_a(DeltaLampTileEntity::new, (Block[])new Block[]{ModBlocks.DELTA_LAMP}).func_206865_a(null);
            type3.setRegistryName("lightestlamp", "delta_te");
            TileEntityType type4 = TileEntityType.Builder.func_223042_a(EpsilonLampTileEntity::new, (Block[])new Block[]{ModBlocks.EPSILON_LAMP}).func_206865_a(null);
            type4.setRegistryName("lightestlamp", "epsilon_te");
            TileEntityType type5 = TileEntityType.Builder.func_223042_a(ZetaLampTileEntity::new, (Block[])new Block[]{ModBlocks.ZETA_LAMP}).func_206865_a(null);
            type5.setRegistryName("lightestlamp", "zeta_te");
            TileEntityType type6 = TileEntityType.Builder.func_223042_a(OmegaLampTileEntity::new, (Block[])new Block[]{ModBlocks.OMEGA_LAMP}).func_206865_a(null);
            type6.setRegistryName("lightestlamp", "omega_te");
            TileEntityType type7 = TileEntityType.Builder.func_223042_a(DeepSeaLanternTileEntity::new, (Block[])new Block[]{ModBlocks.DEEP_SEA_LANTERN}).func_206865_a(null);
            type7.setRegistryName("lightestlamp", "deep_sea_lantern_te");
            TileEntityType type8 = TileEntityType.Builder.func_223042_a(OceanLanternTileEntity::new, (Block[])new Block[]{ModBlocks.OCEAN_LANTERN}).func_206865_a(null);
            type8.setRegistryName("lightestlamp", "ocean_lantern_te");
            TileEntityType type9 = TileEntityType.Builder.func_223042_a(ClearSeaLanternTileEntity::new, (Block[])new Block[]{ModBlocks.CLEAR_SEA_LANTERN}).func_206865_a(null);
            type9.setRegistryName("lightestlamp", "clear_sea_lantern_te");
            TileEntityType type10 = TileEntityType.Builder.func_223042_a(AlchemicalLampTileEntity::new, (Block[])new Block[]{ModBlocks.ALCHEMICAL_LAMP}).func_206865_a(null);
            type10.setRegistryName("lightestlamp", "alchemical_lamp_te");
            TileEntityType centrifuge_te = TileEntityType.Builder.func_223042_a(GasCentrifugeTile::new, (Block[])new Block[]{ModBlocks.GAS_EXTRACTOR}).func_206865_a(null);
            centrifuge_te.setRegistryName("lightestlamp", "centrifuge_te");
            TileEntityType eta_te = TileEntityType.Builder.func_223042_a(EtaLampTileEntity::new, (Block[])new Block[]{ModBlocks.ETA_LAMP}).func_206865_a(null);
            eta_te.setRegistryName("lightestlamp", "eta_te");
            ModTileEntities.ETA_TE = eta_te;
            evt.getRegistry().register(ModTileEntities.ETA_TE);
            TileEntityType deep_ocean_lantern_te = TileEntityType.Builder.func_223042_a(DeepOceanLanternTileEntity::new, (Block[])new Block[]{ModBlocks.DEEP_OCEAN_LANTERN}).func_206865_a(null);
            deep_ocean_lantern_te.setRegistryName("lightestlamp", "deep_ocean_lantern_te");
            ModTileEntities.DEEPOCEANLANTERN_TE = deep_ocean_lantern_te;
            evt.getRegistry().register(ModTileEntities.DEEPOCEANLANTERN_TE);
            TileEntityType abyssal_lantern_te = TileEntityType.Builder.func_223042_a(AbyssalLanternTileEntity::new, (Block[])new Block[]{ModBlocks.ABYSSAL_LANTERN}).func_206865_a(null);
            abyssal_lantern_te.setRegistryName("lightestlamp", "abyssal_lantern_te");
            ModTileEntities.ABYSSALLANTERN_TE = abyssal_lantern_te;
            evt.getRegistry().register(ModTileEntities.ABYSSALLANTERN_TE);
            TileEntityType occ_te = TileEntityType.Builder.func_223042_a(OmegaChunkCleanerTileEntity::new, (Block[])new Block[]{ModBlocks.OCC}).func_206865_a(null);
            occ_te.setRegistryName("lightestlamp", "occ_te");
            ModTileEntities.OCC_TE = occ_te;
            evt.getRegistry().register(ModTileEntities.OCC_TE);
            ModTileEntities.ALFA_TE = type0;
            ModTileEntities.BETA_TE = type1;
            ModTileEntities.GAMMA_TE = type2;
            ModTileEntities.DELTA_TE = type3;
            ModTileEntities.EPSILON_TE = type4;
            ModTileEntities.ZETA_TE = type5;
            ModTileEntities.OMEGA_TE = type6;
            ModTileEntities.DEEPSEALANTERN_TE = type7;
            ModTileEntities.OCEANLANTERN_TE = type8;
            ModTileEntities.CLEARSEALANTERN_TE = type9;
            ModTileEntities.ALCHEMICALLAMP_TE = type10;
            ModTileEntities.CENTRIFUGE_TE = centrifuge_te;
            evt.getRegistry().register(ModTileEntities.ALFA_TE);
            evt.getRegistry().register(ModTileEntities.BETA_TE);
            evt.getRegistry().register(ModTileEntities.GAMMA_TE);
            evt.getRegistry().register(ModTileEntities.DELTA_TE);
            evt.getRegistry().register(ModTileEntities.EPSILON_TE);
            evt.getRegistry().register(ModTileEntities.ZETA_TE);
            evt.getRegistry().register(ModTileEntities.OMEGA_TE);
            evt.getRegistry().register(ModTileEntities.DEEPSEALANTERN_TE);
            evt.getRegistry().register(ModTileEntities.OCEANLANTERN_TE);
            evt.getRegistry().register(ModTileEntities.CLEARSEALANTERN_TE);
            evt.getRegistry().register(ModTileEntities.ALCHEMICALLAMP_TE);
            evt.getRegistry().register(ModTileEntities.CENTRIFUGE_TE);
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ANTI_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ANTI_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.CLEAR_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.CLEAR_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ALFA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ALFA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.BETA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.BETA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.GAMMA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.GAMMA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.DELTA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.DELTA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.EPSILON_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.EPSILON_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ZETA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ZETA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ETA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ETA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.OMEGA_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.OMEGA_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.CLEAR_SEA_LANTERN, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.CLEAR_SEA_LANTERN.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.DEEP_SEA_LANTERN, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.DEEP_SEA_LANTERN.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.OCEAN_LANTERN, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.OCEAN_LANTERN.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.DEEP_OCEAN_LANTERN, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.DEEP_OCEAN_LANTERN.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ALCHEMICAL_LAMP, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ALCHEMICAL_LAMP.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ABYSSAL_LANTERN, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ABYSSAL_LANTERN.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.JUNGLE_LANTERN, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.JUNGLE_LANTERN.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.NEON_ROD_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.NEON_ROD_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ARGON_ROD_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ARGON_ROD_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.KRYPTON_ROD_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.KRYPTON_ROD_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.XENON_ROD_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.XENON_ROD_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.RADON_ROD_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.RADON_ROD_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.NEON_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.NEON_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.ARGON_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.ARGON_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.KRYPTON_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.KRYPTON_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.XENON_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.XENON_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.RADON_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.RADON_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.GLOWING_GLASS_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.GLOWING_GLASS_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.VANTA_BLACK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.VANTA_BLACK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.GAS_EXTRACTOR, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.GAS_EXTRACTOR.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.BORON_ORE, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.BORON_ORE.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.CHUNK_CLEANER, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.CHUNK_CLEANER.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.LUMINATIUM_BLOCK, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.LUMINATIUM_BLOCK.getRegistryName()));
            itemRegistryEvent.getRegistry().register(new BlockItem(ModBlocks.OCC, new Item.Properties().func_200916_a(main_group)).setRegistryName(ModBlocks.OCC.getRegistryName()));
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.EMPTY_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_ROD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORON_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ALCHEMICAL_DUST);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORON_PILE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORON_INGOT);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORON_NUGGET);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.CARBON_NANOTUBE);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.MOON_SHARD);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.CHORUS_FIBER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BROMINE_CRYSTAL);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.STICKANDBOWL);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORIC_ACID);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BASIC_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.NEON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ARGON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.KRYPTON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.XENON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.RADON_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BROMINE_FILTER);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.BORON_MESH);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.ALCHEMICAL_MESH);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.DEBUG_STICK);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)ModItems.GLOWING_DUST_AGGLOMERATIO);
        }
    }
}

