/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.magmator;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import owmii.lib.block.TileBase;
import owmii.lib.util.IVariant;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.magmator.MagmatorBlock;

public class MagmatorTile
extends TileBase.EnergyProvider<Tier, MagmatorBlock> {
    protected final FluidTank tank = new FluidTank(4000){

        public boolean isFluidValid(FluidStack stack) {
            return PowahAPI.MAGMATIC_FLUIDS.containsKey(stack.getFluid()) && super.isFluidValid(stack);
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            MagmatorTile.this.sync(10);
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public MagmatorTile(Tier variant) {
        super(ITiles.MAGMATOR, (IVariant)variant);
    }

    public MagmatorTile() {
        this(Tier.STARTER);
    }

    public void readStorable(CompoundNBT compound) {
        this.tank.readFromNBT(compound);
        super.readStorable(compound);
    }

    public CompoundNBT writeStorable(CompoundNBT compound) {
        this.tank.writeToNBT(compound);
        return super.writeStorable(compound);
    }

    public void generate(World world) {
        int fluidHeat;
        FluidStack fluid;
        if (this.nextBuff <= 0L && !this.tank.isEmpty() && PowahAPI.MAGMATIC_FLUIDS.containsKey((fluid = this.tank.getFluid()).getFluid()) && (fluidHeat = PowahAPI.getMagmaticFluidHeat(fluid.getFluid())) > 0) {
            int minStored = Math.min(this.tank.getFluidAmount(), 100);
            this.nextBuff = this.buffer = (long)(minStored * fluidHeat / 100);
            this.tank.drain(minStored, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public boolean hasEnergyBuffer() {
        return true;
    }

    public int getChargingSlots() {
        return 1;
    }

    public boolean keepEnergy() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }
}

